/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.internal;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobBuilder;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.options.CopyOptions;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.util.BlobUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.util.Closeables2;
import org.jclouds.util.Predicates2;

public abstract class BaseBlobStore
implements BlobStore {
    protected final BlobStoreContext context;
    protected final BlobUtils blobUtils;
    protected final Supplier<Location> defaultLocation;
    protected final Supplier<Set<? extends Location>> locations;

    @Inject
    protected BaseBlobStore(BlobStoreContext context, BlobUtils blobUtils, Supplier<Location> defaultLocation, @Memoized Supplier<Set<? extends Location>> locations) {
        this.context = (BlobStoreContext)Preconditions.checkNotNull((Object)context, (Object)"context");
        this.blobUtils = (BlobUtils)Preconditions.checkNotNull((Object)blobUtils, (Object)"blobUtils");
        this.defaultLocation = (Supplier)Preconditions.checkNotNull(defaultLocation, (Object)"defaultLocation");
        this.locations = (Supplier)Preconditions.checkNotNull(locations, (Object)"locations");
    }

    @Override
    public BlobStoreContext getContext() {
        return this.context;
    }

    @Override
    public BlobBuilder blobBuilder(String name) {
        return this.blobUtils.blobBuilder().name(name);
    }

    @Override
    public PageSet<? extends StorageMetadata> list(String container) {
        return this.list(container, ListContainerOptions.NONE);
    }

    @Override
    public boolean directoryExists(String containerName, String directory) {
        return this.blobUtils.directoryExists(containerName, directory);
    }

    @Override
    public void createDirectory(String containerName, String directory) {
        this.blobUtils.createDirectory(containerName, directory);
    }

    @Override
    public void removeBlobs(String container, Iterable<String> names) {
        for (String name : names) {
            this.removeBlob(container, name);
        }
    }

    @Override
    public long countBlobs(String container) {
        return this.countBlobs(container, ListContainerOptions.Builder.recursive());
    }

    @Override
    public long countBlobs(String containerName, ListContainerOptions options) {
        return this.blobUtils.countBlobs(containerName, options);
    }

    @Override
    public void clearContainer(String containerName) {
        this.clearContainer(containerName, ListContainerOptions.Builder.recursive());
    }

    @Override
    public void clearContainer(String containerName, ListContainerOptions options) {
        this.blobUtils.clearContainer(containerName, options);
    }

    @Override
    public void deleteDirectory(String containerName, String directory) {
        this.blobUtils.deleteDirectory(containerName, directory);
    }

    @Override
    public Blob getBlob(String container, String key) {
        return this.getBlob(container, key, GetOptions.NONE);
    }

    @Override
    public void deleteContainer(String container) {
        this.deletePathAndEnsureGone(container);
    }

    @Override
    public boolean deleteContainerIfEmpty(String container) {
        try {
            return this.deleteAndVerifyContainerGone(container);
        }
        catch (ContainerNotFoundException cnfe) {
            return true;
        }
    }

    protected void deletePathAndEnsureGone(String path) {
        Preconditions.checkState((boolean)Predicates2.retry((Predicate)new Predicate<String>(){

            public boolean apply(String in) {
                try {
                    BaseBlobStore.this.clearContainer(in, ListContainerOptions.Builder.recursive());
                    return BaseBlobStore.this.deleteAndVerifyContainerGone(in);
                }
                catch (ContainerNotFoundException e) {
                    return true;
                }
            }
        }, (long)30000L).apply((Object)path), (String)"%s still exists after deleting!", (Object[])new Object[]{path});
    }

    @Override
    public Set<? extends Location> listAssignableLocations() {
        return (Set)this.locations.get();
    }

    protected abstract boolean deleteAndVerifyContainerGone(String var1);

    @Override
    public String copyBlob(String fromContainer, String fromName, String toContainer, String toName, CopyOptions options) {
        Blob blob = this.getBlob(fromContainer, fromName);
        if (blob == null) {
            throw new KeyNotFoundException(fromContainer, fromName, "while copying");
        }
        InputStream is = null;
        try {
            Optional<Map<String, String>> userMetadata;
            is = blob.getPayload().openStream();
            MutableContentMetadata metadata = blob.getMetadata().getContentMetadata();
            BlobBuilder.PayloadBlobBuilder builder = this.blobBuilder(toName).payload(is).contentDisposition(metadata.getContentDisposition()).contentEncoding(metadata.getContentEncoding()).contentLanguage(metadata.getContentLanguage()).contentType(metadata.getContentType());
            Long contentLength = metadata.getContentLength();
            if (contentLength != null) {
                builder.contentLength(contentLength);
            }
            if ((userMetadata = options.getUserMetadata()).isPresent()) {
                builder.userMetadata((Map)userMetadata.get());
            } else {
                builder.userMetadata(blob.getMetadata().getUserMetadata());
            }
            String string = this.putBlob(toContainer, builder.build());
            return string;
        }
        catch (IOException ioe) {
            throw Throwables.propagate((Throwable)ioe);
        }
        finally {
            Closeables2.closeQuietly((Closeable)is);
        }
    }
}

