/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.NodeMetadata;

public class NodePredicates {
    public static final Predicate<NodeMetadata> RUNNING = new Predicate<NodeMetadata>(){

        public boolean apply(NodeMetadata nodeMetadata) {
            return nodeMetadata.getStatus() == NodeMetadata.Status.RUNNING;
        }

        public String toString() {
            return NodeMetadata.Status.RUNNING.toString();
        }
    };
    public static final Predicate<NodeMetadata> TERMINATED = new Predicate<NodeMetadata>(){

        public boolean apply(NodeMetadata nodeMetadata) {
            return nodeMetadata.getStatus() == NodeMetadata.Status.TERMINATED;
        }

        public String toString() {
            return NodeMetadata.Status.TERMINATED.toString();
        }
    };
    public static final Predicate<NodeMetadata> SUSPENDED = new Predicate<NodeMetadata>(){

        public boolean apply(NodeMetadata nodeMetadata) {
            return nodeMetadata.getStatus() == NodeMetadata.Status.SUSPENDED;
        }

        public String toString() {
            return NodeMetadata.Status.SUSPENDED.toString();
        }
    };

    public static Predicate<ComputeMetadata> locationId(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id must be defined");
        return new LocationId(id);
    }

    public static Predicate<ComputeMetadata> parentLocationId(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id must be defined");
        return new ParentLocationId(id);
    }

    public static <T extends ComputeMetadata> Predicate<T> withIds(String ... ids) {
        Preconditions.checkNotNull((Object)ids, (Object)"ids must be defined");
        ImmutableSet search = ImmutableSet.copyOf((Object[])ids);
        return new Predicate<T>((Set)search){
            final /* synthetic */ Set val$search;
            {
                this.val$search = set;
            }

            public boolean apply(T nodeMetadata) {
                return this.val$search.contains(nodeMetadata.getId());
            }

            public String toString() {
                return "withIds(" + this.val$search + ")";
            }
        };
    }

    public static Predicate<ComputeMetadata> all() {
        return Predicates.alwaysTrue();
    }

    public static Predicate<NodeMetadata> inGroup(final String group) {
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)group), (Object)"group must be defined");
        return new Predicate<NodeMetadata>(){

            public boolean apply(NodeMetadata nodeMetadata) {
                return group.equals(nodeMetadata.getGroup());
            }

            public String toString() {
                return "inGroup(" + group + ")";
            }
        };
    }

    public static Predicate<NodeMetadata> hasGroup() {
        return new Predicate<NodeMetadata>(){

            public boolean apply(NodeMetadata nodeMetadata) {
                return nodeMetadata != null && nodeMetadata.getGroup() != null;
            }

            public String toString() {
                return "hasGroup()";
            }
        };
    }

    public static Predicate<NodeMetadata> runningInGroup(final String group) {
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)group), (Object)"group must be defined");
        return new Predicate<NodeMetadata>(){

            public boolean apply(NodeMetadata nodeMetadata) {
                return group.equals(nodeMetadata.getGroup()) && nodeMetadata.getStatus() == NodeMetadata.Status.RUNNING;
            }

            public String toString() {
                return "runningInGroup(" + group + ")";
            }
        };
    }

    private static class LocationId
    implements Predicate<ComputeMetadata> {
        private final String id;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LocationId other = (LocationId)obj;
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }

        private LocationId(String id) {
            this.id = id;
        }

        public boolean apply(ComputeMetadata nodeMetadata) {
            return this.id.equals(nodeMetadata.getLocation().getId());
        }

        public String toString() {
            return "locationId(" + this.id + ")";
        }
    }

    private static class ParentLocationId
    implements Predicate<ComputeMetadata> {
        private final String id;

        private ParentLocationId(String id) {
            this.id = id;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ParentLocationId other = (ParentLocationId)obj;
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }

        public boolean apply(ComputeMetadata nodeMetadata) {
            if (nodeMetadata.getLocation().getParent() == null) {
                return false;
            }
            return this.id.equals(nodeMetadata.getLocation().getParent().getId());
        }

        public String toString() {
            return "ParentLocationId [id=" + this.id + "]";
        }
    }
}

