/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ovf.xml;

import javax.inject.Provider;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.ovf.Section;
import org.jclouds.util.SaxUtils;

public class SectionHandler<T extends Section<T>, B extends Section.Builder<T>>
extends ParseSax.HandlerWithResult<T> {
    protected final Provider<? extends Section.Builder<T>> builderProvider;
    protected StringBuilder currentText = new StringBuilder();
    protected B builder;

    public static SectionHandler create() {
        return new SectionHandler(new Provider<Section.Builder>(){

            public Section.Builder get() {
                return new Section.Builder();
            }
        });
    }

    public SectionHandler(Provider<B> builderProvider) {
        this.builderProvider = builderProvider;
        this.builder = (Section.Builder)builderProvider.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getResult() {
        try {
            Section section = ((Section.Builder)this.builder).build();
            return (T)section;
        }
        finally {
            this.builder = (Section.Builder)this.builderProvider.get();
        }
    }

    public void endElement(String uri, String localName, String qName) {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"Info")) {
            ((Section.Builder)this.builder).info(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

