/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier;

import com.google.common.hash.HashCode;
import java.io.Closeable;
import java.net.URI;
import java.util.Map;
import org.jclouds.glacier.domain.ArchiveMetadataCollection;
import org.jclouds.glacier.domain.JobMetadata;
import org.jclouds.glacier.domain.JobRequest;
import org.jclouds.glacier.domain.MultipartUploadMetadata;
import org.jclouds.glacier.domain.PaginatedJobCollection;
import org.jclouds.glacier.domain.PaginatedMultipartUploadCollection;
import org.jclouds.glacier.domain.PaginatedVaultCollection;
import org.jclouds.glacier.domain.VaultMetadata;
import org.jclouds.glacier.options.PaginationOptions;
import org.jclouds.glacier.util.ContentRange;
import org.jclouds.io.Payload;

public interface GlacierClient
extends Closeable {
    public URI createVault(String var1);

    public boolean deleteVault(String var1);

    public VaultMetadata describeVault(String var1);

    public PaginatedVaultCollection listVaults(PaginationOptions var1);

    public PaginatedVaultCollection listVaults();

    public String uploadArchive(String var1, Payload var2, String var3);

    public String uploadArchive(String var1, Payload var2);

    public boolean deleteArchive(String var1, String var2);

    public String initiateMultipartUpload(String var1, long var2, String var4);

    public String initiateMultipartUpload(String var1, long var2);

    public HashCode uploadPart(String var1, String var2, ContentRange var3, Payload var4);

    public String completeMultipartUpload(String var1, String var2, Map<Integer, HashCode> var3, long var4);

    public boolean abortMultipartUpload(String var1, String var2);

    public MultipartUploadMetadata listParts(String var1, String var2, PaginationOptions var3);

    public MultipartUploadMetadata listParts(String var1, String var2);

    public PaginatedMultipartUploadCollection listMultipartUploads(String var1, PaginationOptions var2);

    public PaginatedMultipartUploadCollection listMultipartUploads(String var1);

    public String initiateJob(String var1, JobRequest var2);

    public JobMetadata describeJob(String var1, String var2);

    public PaginatedJobCollection listJobs(String var1, PaginationOptions var2);

    public PaginatedJobCollection listJobs(String var1);

    public Payload getJobOutput(String var1, String var2, ContentRange var3);

    public Payload getJobOutput(String var1, String var2);

    public ArchiveMetadataCollection getInventoryRetrievalOutput(String var1, String var2);
}

