/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier.blobstore;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.internal.BlobImpl;
import org.jclouds.blobstore.domain.internal.MutableBlobMetadataImpl;
import org.jclouds.blobstore.internal.BaseBlobStore;
import org.jclouds.blobstore.options.CreateContainerOptions;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.blobstore.util.BlobUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.glacier.GlacierClient;
import org.jclouds.glacier.blobstore.functions.ArchiveMetadataCollectionToStorageMetadata;
import org.jclouds.glacier.blobstore.functions.ListContainerOptionsToInventoryRetrievalJobRequest;
import org.jclouds.glacier.blobstore.functions.PaginatedVaultCollectionToStorageMetadata;
import org.jclouds.glacier.blobstore.strategy.MultipartUploadStrategy;
import org.jclouds.glacier.blobstore.strategy.PollingStrategy;
import org.jclouds.glacier.domain.ArchiveRetrievalJobRequest;
import org.jclouds.glacier.util.ContentRange;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.util.Predicates2;

@Singleton
public class GlacierBlobStore
extends BaseBlobStore {
    public static final long DEFAULT_INVENTORY_UPDATE_TIME = TimeUnit.HOURS.toMillis(24L);
    @Inject(optional=true)
    @Named(value="jclouds.glacier.inventory.update.time")
    private final long inventoryUpdateTime = DEFAULT_INVENTORY_UPDATE_TIME;
    private final GlacierClient sync;
    private final Provider<MultipartUploadStrategy> multipartUploadStrategy;
    private final Provider<PollingStrategy> pollingStrategy;
    private final PaginatedVaultCollectionToStorageMetadata vaultsToContainers;
    private final ArchiveMetadataCollectionToStorageMetadata archivesToBlobs;
    private final ListContainerOptionsToInventoryRetrievalJobRequest containerOptionsToInventoryRetrieval;

    @Inject
    GlacierBlobStore(BlobStoreContext context, BlobUtils blobUtils, Supplier<Location> defaultLocation, @Memoized Supplier<Set<? extends Location>> locations, GlacierClient sync, Provider<MultipartUploadStrategy> multipartUploadStrategy, Provider<PollingStrategy> pollingStrategy, PaginatedVaultCollectionToStorageMetadata vaultsToContainers, ArchiveMetadataCollectionToStorageMetadata archivesToBlobs, ListContainerOptionsToInventoryRetrievalJobRequest containerOptionsToInventoryRetrieval) {
        super(context, blobUtils, defaultLocation, locations);
        this.containerOptionsToInventoryRetrieval = (ListContainerOptionsToInventoryRetrievalJobRequest)Preconditions.checkNotNull((Object)containerOptionsToInventoryRetrieval, (Object)"containerOptionsToInventoryRetrieval");
        this.archivesToBlobs = (ArchiveMetadataCollectionToStorageMetadata)Preconditions.checkNotNull((Object)archivesToBlobs, (Object)"archivesToBlobs");
        this.pollingStrategy = (Provider)Preconditions.checkNotNull(pollingStrategy, (Object)"pollingStrategy");
        this.vaultsToContainers = (PaginatedVaultCollectionToStorageMetadata)Preconditions.checkNotNull((Object)vaultsToContainers, (Object)"vaultsToContainers");
        this.multipartUploadStrategy = (Provider)Preconditions.checkNotNull(multipartUploadStrategy, (Object)"multipartUploadStrategy");
        this.sync = (GlacierClient)Preconditions.checkNotNull((Object)sync, (Object)"sync");
    }

    public void deleteContainer(String container) {
        if (!this.sync.deleteVault(container)) {
            this.deletePathAndEnsureGone(container);
        }
    }

    protected void deletePathAndEnsureGone(String container) {
        Preconditions.checkState((boolean)Predicates2.retry((Predicate)new Predicate<String>(){

            public boolean apply(String container) {
                GlacierBlobStore.this.clearContainer(container);
                return GlacierBlobStore.this.sync.deleteVault(container);
            }
        }, (long)this.inventoryUpdateTime).apply((Object)container), (String)"%s still exists after deleting!", (Object[])new Object[]{container});
    }

    protected boolean deleteAndVerifyContainerGone(String container) {
        return this.sync.deleteVault(container);
    }

    public PageSet<? extends StorageMetadata> list() {
        return this.vaultsToContainers.apply(this.sync.listVaults());
    }

    public boolean containerExists(String container) {
        return this.sync.describeVault(container) != null;
    }

    public boolean createContainerInLocation(@Nullable Location location, String container) {
        return this.sync.createVault(container) != null;
    }

    public boolean createContainerInLocation(@Nullable Location location, String container, CreateContainerOptions options) {
        return this.createContainerInLocation(location, container);
    }

    public PageSet<? extends StorageMetadata> list(String container, ListContainerOptions listContainerOptions) {
        String jobId = this.sync.initiateJob(container, this.containerOptionsToInventoryRetrieval.apply(listContainerOptions));
        try {
            if (((PollingStrategy)this.pollingStrategy.get()).waitForSuccess(container, jobId)) {
                return this.archivesToBlobs.apply(this.sync.getInventoryRetrievalOutput(container, jobId));
            }
            return null;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean blobExists(String container, String key) {
        return this.blobMetadata(container, key) != null;
    }

    public String putBlob(String container, Blob blob) {
        return this.sync.uploadArchive(container, blob.getPayload());
    }

    public String putBlob(String container, Blob blob, PutOptions options) {
        if (options.isMultipart()) {
            return ((MultipartUploadStrategy)this.multipartUploadStrategy.get()).execute(container, blob);
        }
        return this.putBlob(container, blob);
    }

    public BlobMetadata blobMetadata(String container, String key) {
        PageSet<? extends StorageMetadata> blobs = this.list(container, null);
        for (StorageMetadata blob : blobs) {
            if (!blob.getName().equals(key)) continue;
            return (BlobMetadata)blob;
        }
        return null;
    }

    private ArchiveRetrievalJobRequest buildArchiveRetrievalRequest(String key, GetOptions getOptions) {
        ArchiveRetrievalJobRequest.Builder requestBuilder = ArchiveRetrievalJobRequest.builder().archiveId(key);
        if (getOptions != null) {
            Preconditions.checkArgument((getOptions.getRanges().size() <= 1 ? 1 : 0) != 0);
            if (getOptions.getRanges().size() == 1) {
                requestBuilder.range(ContentRange.fromString((String)getOptions.getRanges().get(0)));
            }
        }
        return requestBuilder.build();
    }

    public Blob getBlob(String container, String key, GetOptions getOptions) {
        String jobId = this.sync.initiateJob(container, this.buildArchiveRetrievalRequest(key, getOptions));
        try {
            if (((PollingStrategy)this.pollingStrategy.get()).waitForSuccess(container, jobId)) {
                MutableBlobMetadataImpl blobMetadata = new MutableBlobMetadataImpl();
                blobMetadata.setContainer(container);
                blobMetadata.setName(key);
                BlobImpl blob = new BlobImpl((MutableBlobMetadata)blobMetadata);
                blob.setPayload(this.sync.getJobOutput(container, jobId));
                return blob;
            }
            return null;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeBlob(String container, String key) {
        this.sync.deleteArchive(container, key);
    }
}

