/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier.blobstore.strategy.internal;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.concurrent.TimeUnit;
import org.jclouds.glacier.GlacierClient;
import org.jclouds.glacier.blobstore.strategy.PollingStrategy;
import org.jclouds.glacier.domain.JobMetadata;
import org.jclouds.glacier.domain.JobStatus;

@Singleton
public class BasePollingStrategy
implements PollingStrategy {
    public static final long DEFAULT_INITIAL_WAIT = TimeUnit.HOURS.toMillis(3L);
    public static final long DEFAULT_TIME_BETWEEN_POLLS = TimeUnit.MINUTES.toMillis(15L);
    private final GlacierClient client;
    private final long initialWait;
    private final long timeBetweenPolls;

    public BasePollingStrategy(long initialWait, long timeBetweenPolls, GlacierClient client) {
        this.initialWait = initialWait;
        this.timeBetweenPolls = timeBetweenPolls;
        this.client = (GlacierClient)Preconditions.checkNotNull((Object)client, (Object)"client");
    }

    @Inject
    public BasePollingStrategy(GlacierClient client) {
        this(DEFAULT_INITIAL_WAIT, DEFAULT_TIME_BETWEEN_POLLS, client);
    }

    private boolean inProgress(String job, String vault) {
        JobMetadata jobMetadata = this.client.describeJob(vault, job);
        return jobMetadata != null && jobMetadata.getStatusCode() == JobStatus.IN_PROGRESS;
    }

    private void waitForJob(String job, String vault) throws InterruptedException {
        Thread.sleep(this.initialWait);
        while (this.inProgress(job, vault)) {
            Thread.sleep(this.timeBetweenPolls);
        }
    }

    private boolean succeeded(String job, String vault) {
        JobMetadata jobMetadata = this.client.describeJob(vault, job);
        return jobMetadata != null && jobMetadata.getStatusCode() == JobStatus.SUCCEEDED;
    }

    @Override
    public boolean waitForSuccess(String vault, String job) throws InterruptedException {
        if (this.client.describeJob(vault, job) == null) {
            return false;
        }
        this.waitForJob(job, vault);
        return this.succeeded(job, vault);
    }
}

