/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import java.beans.ConstructorProperties;
import java.util.Date;
import org.jclouds.glacier.domain.InventoryRetrievalParameters;
import org.jclouds.glacier.domain.JobStatus;
import org.jclouds.glacier.util.ContentRange;
import org.jclouds.javax.annotation.Nullable;

public class JobMetadata {
    @SerializedName(value="Action")
    private final String action;
    @SerializedName(value="ArchiveId")
    private final String archiveId;
    @SerializedName(value="ArchiveSizeInBytes")
    private final Long archiveSizeInBytes;
    @SerializedName(value="ArchiveSHA256TreeHash")
    private final String archiveSHA256TreeHash;
    @SerializedName(value="Completed")
    private final boolean completed;
    @SerializedName(value="CompletionDate")
    private final Date completionDate;
    @SerializedName(value="CreationDate")
    private final Date creationDate;
    @SerializedName(value="InventorySizeInBytes")
    private final Long inventorySizeInBytes;
    @SerializedName(value="JobDescription")
    private final String jobDescription;
    @SerializedName(value="JobId")
    private final String jobId;
    @SerializedName(value="RetrievalByteRange")
    private final ContentRange retrievalByteRange;
    @SerializedName(value="SHA256TreeHash")
    private final String sha256TreeHash;
    @SerializedName(value="SNSTopic")
    private final String snsTopic;
    @SerializedName(value="StatusCode")
    private final JobStatus statusCode;
    @SerializedName(value="StatusMessage")
    private final String statusMessage;
    @SerializedName(value="VaultARN")
    private final String vaultArn;
    @SerializedName(value="InventoryRetrievalParameters")
    private final InventoryRetrievalParameters parameters;

    @ConstructorProperties(value={"Action", "ArchiveId", "ArchiveSizeInBytes", "ArchiveSHA256TreeHash", "Completed", "CompletionDate", "CreationDate", "InventorySizeInBytes", "JobDescription", "JobId", "RetrievalByteRange", "SHA256TreeHash", "SNSTopic", "StatusCode", "StatusMessage", "VaultARN", "InventoryRetrievalParameters"})
    public JobMetadata(String action, @Nullable String archiveId, @Nullable Long archiveSizeInBytes, @Nullable String archiveSHA256TreeHash, boolean completed, @Nullable Date completionDate, Date creationDate, @Nullable Long inventorySizeInBytes, @Nullable String jobDescription, String jobId, @Nullable String retrievalByteRange, @Nullable String sha256TreeHash, @Nullable String snsTopic, String statusCode, @Nullable String statusMessage, String vaultArn, @Nullable InventoryRetrievalParameters parameters) {
        this.action = (String)Preconditions.checkNotNull((Object)action, (Object)"action");
        this.archiveId = archiveId;
        this.archiveSizeInBytes = archiveSizeInBytes;
        this.archiveSHA256TreeHash = archiveSHA256TreeHash;
        this.completed = (Boolean)Preconditions.checkNotNull((Object)completed, (Object)"completed");
        this.completionDate = completionDate == null ? null : (Date)completionDate.clone();
        this.creationDate = (Date)((Date)Preconditions.checkNotNull((Object)creationDate, (Object)"creationDate")).clone();
        this.inventorySizeInBytes = inventorySizeInBytes;
        this.jobDescription = jobDescription;
        this.jobId = (String)Preconditions.checkNotNull((Object)jobId, (Object)"jobId");
        this.retrievalByteRange = retrievalByteRange == null ? null : ContentRange.fromString(retrievalByteRange);
        this.sha256TreeHash = sha256TreeHash;
        this.snsTopic = snsTopic;
        this.statusCode = JobStatus.fromString((String)Preconditions.checkNotNull((Object)statusCode, (Object)"statusCode"));
        this.statusMessage = statusMessage;
        this.vaultArn = (String)Preconditions.checkNotNull((Object)vaultArn, (Object)"vaultArn");
        this.parameters = parameters;
    }

    public String getAction() {
        return this.action;
    }

    public String getArchiveId() {
        return this.archiveId;
    }

    public Long getArchiveSizeInBytes() {
        return this.archiveSizeInBytes;
    }

    public String getArchiveSHA256TreeHash() {
        return this.archiveSHA256TreeHash;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public Date getCompletionDate() {
        return this.completionDate == null ? null : (Date)this.completionDate.clone();
    }

    public Date getCreationDate() {
        return (Date)this.creationDate.clone();
    }

    public Long getInventorySizeInBytes() {
        return this.inventorySizeInBytes;
    }

    public String getJobDescription() {
        return this.jobDescription;
    }

    public String getJobId() {
        return this.jobId;
    }

    public ContentRange getRetrievalByteRange() {
        return this.retrievalByteRange;
    }

    public String getSha256TreeHash() {
        return this.sha256TreeHash;
    }

    public String getSnsTopic() {
        return this.snsTopic;
    }

    public JobStatus getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public String getVaultArn() {
        return this.vaultArn;
    }

    public InventoryRetrievalParameters getParameters() {
        return this.parameters;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.action, this.archiveId, this.archiveSizeInBytes, this.archiveSHA256TreeHash, this.completed, this.completionDate, this.creationDate, this.inventorySizeInBytes, this.jobDescription, this.jobId, this.retrievalByteRange, this.sha256TreeHash, this.snsTopic, this.statusCode, this.statusMessage, this.vaultArn, this.parameters});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JobMetadata other = (JobMetadata)obj;
        return Objects.equal((Object)this.jobId, (Object)other.jobId);
    }

    public String toString() {
        return "JobMetadata [jobId=" + this.jobId + ", statusCode=" + (Object)((Object)this.statusCode) + ", statusMessage=" + this.statusMessage + "]";
    }
}

