/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier.predicates.validators;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.inject.Singleton;
import org.jclouds.predicates.Validator;

@Singleton
public final class DescriptionValidator
extends Validator<String> {
    private static final int MAX_DESC_LENGTH = 1024;
    private static final CharMatcher DESCRIPTION_ACCEPTABLE_RANGE = CharMatcher.inRange((char)' ', (char)'~');

    public void validate(String description) {
        if (Strings.isNullOrEmpty((String)description)) {
            return;
        }
        Preconditions.checkArgument((description.length() <= 1024 ? 1 : 0) != 0, (String)"Description can't be longer than %d characters but was %d", (Object[])new Object[]{1024, description.length()});
        Preconditions.checkArgument((boolean)DESCRIPTION_ACCEPTABLE_RANGE.matchesAllOf((CharSequence)description), (Object)"Description should have ASCII values between 32 and 126.");
    }
}

