/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier.util;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingInputStream;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.jclouds.io.Payload;

public final class TreeHash {
    private static final int CHUNK_SIZE = 0x100000;
    private final HashCode treeHash;
    private final HashCode linearHash;

    private TreeHash(HashCode treeHash, HashCode linearHash) {
        this.treeHash = (HashCode)Preconditions.checkNotNull((Object)treeHash, (Object)"treeHash");
        this.linearHash = (HashCode)Preconditions.checkNotNull((Object)linearHash, (Object)"linearHash");
    }

    public HashCode getLinearHash() {
        return this.linearHash;
    }

    public HashCode getTreeHash() {
        return this.treeHash;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.treeHash, this.linearHash});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TreeHash other = (TreeHash)obj;
        return Objects.equal((Object)this.treeHash, (Object)other.treeHash) && Objects.equal((Object)this.linearHash, (Object)other.linearHash);
    }

    public String toString() {
        return "TreeHash [treeHash=" + this.treeHash + ", linearHash=" + this.linearHash + "]";
    }

    private static HashCode hashList(Collection<HashCode> hashList) {
        ImmutableList.Builder result = ImmutableList.builder();
        while (hashList.size() > 1) {
            Iterator<HashCode> it = hashList.iterator();
            while (it.hasNext()) {
                HashCode hc1 = it.next();
                if (it.hasNext()) {
                    HashCode hc2 = it.next();
                    result.add((Object)Hashing.sha256().newHasher().putBytes(hc1.asBytes()).putBytes(hc2.asBytes()).hash());
                    continue;
                }
                result.add((Object)hc1);
            }
            hashList = result.build();
            result = ImmutableList.builder();
        }
        return hashList.iterator().next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TreeHash buildTreeHashFromPayload(Payload payload) throws IOException {
        TreeHash treeHash;
        InputStream is = null;
        try {
            HashingInputStream chunkedHis;
            long count;
            is = ((Payload)Preconditions.checkNotNull((Object)payload, (Object)"payload")).openStream();
            ImmutableList.Builder list = ImmutableList.builder();
            HashingInputStream linearHis = new HashingInputStream(Hashing.sha256(), is);
            while ((count = ByteStreams.copy((InputStream)(chunkedHis = new HashingInputStream(Hashing.sha256(), ByteStreams.limit((InputStream)linearHis, (long)0x100000L))), (OutputStream)ByteStreams.nullOutputStream())) != 0L) {
                list.add((Object)chunkedHis.hash());
            }
            treeHash = new TreeHash(TreeHash.hashList((Collection<HashCode>)list.build()), linearHis.hash());
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(is);
            throw throwable;
        }
        Closeables.closeQuietly((InputStream)is);
        return treeHash;
    }

    public static HashCode buildTreeHashFromMap(Map<Integer, HashCode> map) {
        Preconditions.checkArgument((!map.isEmpty() ? 1 : 0) != 0, (Object)"The map cannot be empty.");
        return TreeHash.hashList((Collection<HashCode>)ImmutableSortedMap.copyOf(map).values());
    }
}

