/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.googlecomputeengine.domain.Deprecated;

public final class GoogleComputeEngineImageToImage
implements Function<org.jclouds.googlecomputeengine.domain.Image, Image> {
    public Image apply(org.jclouds.googlecomputeengine.domain.Image image) {
        ImageBuilder builder = new ImageBuilder().id(image.selfLink().toString()).providerId(image.id()).name(image.name()).providerId(image.id()).description(image.description()).status(Image.Status.AVAILABLE).uri(image.selfLink());
        if (image.deprecated() != null) {
            builder.userMetadata((Map)ImmutableMap.of((Object)"deprecatedState", (Object)image.deprecated().state().name()));
            if (image.deprecated().state() == Deprecated.State.DELETED) {
                builder.status(Image.Status.DELETED);
            }
        }
        ArrayList splits = Lists.newArrayList((Object[])image.name().split("-"));
        OperatingSystem.Builder osBuilder = this.defaultOperatingSystem(image);
        if (splits == null || splits.size() == 0 || splits.size() < 3) {
            return builder.operatingSystem(osBuilder.build()).build();
        }
        OsFamily family = OsFamily.fromValue((String)((String)splits.get(0)));
        if (family != OsFamily.UNRECOGNIZED) {
            osBuilder.family(family);
        }
        String version = Joiner.on((String)".").join(Iterables.limit((Iterable)Iterables.skip((Iterable)splits, (int)1), (int)(splits.size() - 2)));
        osBuilder.version(version);
        builder.version((String)Iterables.getLast((Iterable)splits));
        return builder.operatingSystem(osBuilder.build()).build();
    }

    private OperatingSystem.Builder defaultOperatingSystem(org.jclouds.googlecomputeengine.domain.Image image) {
        return OperatingSystem.builder().family(OsFamily.LINUX).is64Bit(true).description(image.name());
    }
}

