/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.features;

import com.google.common.base.Function;
import java.net.URI;
import java.util.Iterator;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.googlecloud.config.CurrentProject;
import org.jclouds.googlecloud.domain.ListPage;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.domain.Image;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.internal.BaseArg0ToIteratorOfListPage;
import org.jclouds.googlecomputeengine.internal.BaseToIteratorOfListPage;
import org.jclouds.googlecomputeengine.options.DeprecateOptions;
import org.jclouds.googlecomputeengine.options.ImageCreationOptions;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Endpoint;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.binders.BindToJsonPayload;

@SkipEncoding(value={47, 61})
@RequestFilters(value={OAuthFilter.class})
@Consumes(value={"application/json"})
public interface ImageApi {
    @Named(value="Images:get")
    @GET
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Image get(@EndpointParam URI var1);

    @Named(value="Images:get\u00a0")
    @GET
    @Endpoint(value=CurrentProject.class)
    @Path(value="/global/images/{image}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Image get(@PathParam(value="image") String var1);

    @Named(value="Images:delete")
    @DELETE
    @Endpoint(value=CurrentProject.class)
    @Path(value="/global/images/{image}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Operation delete(@PathParam(value="image") String var1);

    @Named(value="Images:insert")
    @POST
    @Endpoint(value=CurrentProject.class)
    @Path(value="/global/images")
    @Produces(value={"application/json"})
    @MapBinder(value=BindToJsonPayload.class)
    public Operation createFromDisk(@PayloadParam(value="name") String var1, @PayloadParam(value="sourceDisk") String var2);

    @Named(value="Images:insert")
    @POST
    @Endpoint(value=CurrentProject.class)
    @Path(value="/global/images")
    @Produces(value={"application/json"})
    public Operation create(@BinderParam(value=BindToJsonPayload.class) ImageCreationOptions var1);

    @Named(value="Images:deprecate")
    @POST
    @Endpoint(value=CurrentProject.class)
    @Path(value="/global/images/{image}/deprecate")
    public Operation deprecate(@PathParam(value="image") String var1, @BinderParam(value=BindToJsonPayload.class) DeprecateOptions var2);

    @Named(value="Images:list")
    @GET
    @Endpoint(value=CurrentProject.class)
    @Path(value="/global/images")
    public ListPage<Image> listPage(@Nullable @QueryParam(value="pageToken") String var1, ListOptions var2);

    @Named(value="Images:list")
    @GET
    @Endpoint(value=CurrentProject.class)
    @Path(value="/global/images")
    @Transform(value=ImagePages.class)
    public Iterator<ListPage<Image>> list();

    @Named(value="Images:list")
    @GET
    @Endpoint(value=CurrentProject.class)
    @Path(value="/global/images")
    @Transform(value=ImagePages.class)
    public Iterator<ListPage<Image>> list(ListOptions var1);

    @Named(value="Images:list")
    @GET
    @Path(value="/projects/{project}/global/images")
    public ListPage<Image> listPageInProject(@PathParam(value="project") String var1, @Nullable @QueryParam(value="pageToken") String var2, ListOptions var3);

    @Named(value="Images:list")
    @GET
    @Path(value="/projects/{project}/global/images")
    @Transform(value=ImagePagesInProject.class)
    public Iterator<ListPage<Image>> listInProject(@PathParam(value="project") String var1);

    @Named(value="Images:list")
    @GET
    @Path(value="/projects/{project}/global/images")
    @Transform(value=ImagePagesInProject.class)
    public Iterator<ListPage<Image>> listInProject(@PathParam(value="project") String var1, ListOptions var2);

    public static final class ImagePagesInProject
    extends BaseArg0ToIteratorOfListPage<Image, ImagePagesInProject> {
        private final GoogleComputeEngineApi api;

        @Inject
        ImagePagesInProject(GoogleComputeEngineApi api) {
            this.api = api;
        }

        protected Function<String, ListPage<Image>> fetchNextPage(final String projectName, final ListOptions options) {
            return new Function<String, ListPage<Image>>(){

                public ListPage<Image> apply(String pageToken) {
                    return ImagePagesInProject.this.api.images().listPageInProject(projectName, pageToken, options);
                }
            };
        }
    }

    public static final class ImagePages
    extends BaseToIteratorOfListPage<Image, ImagePages> {
        private final GoogleComputeEngineApi api;

        @Inject
        ImagePages(GoogleComputeEngineApi api) {
            this.api = api;
        }

        protected Function<String, ListPage<Image>> fetchNextPage(final ListOptions options) {
            return new Function<String, ListPage<Image>>(){

                public ListPage<Image> apply(String pageToken) {
                    return ImagePages.this.api.images().listPage(pageToken, options);
                }
            };
        }
    }
}

