/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.features;

import com.google.common.base.Function;
import java.net.URI;
import java.util.Iterator;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.googlecloud.config.CurrentProject;
import org.jclouds.googlecloud.domain.ListPage;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.internal.BaseArg0ToIteratorOfListPage;
import org.jclouds.googlecomputeengine.internal.BaseToIteratorOfListPage;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.Endpoint;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.Transform;

@SkipEncoding(value={47, 61})
@RequestFilters(value={OAuthFilter.class})
@Consumes(value={"application/json"})
public interface OperationApi {
    @Named(value="Operations:get")
    @GET
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Operation get(@EndpointParam URI var1);

    @Named(value="Operations:delete")
    @DELETE
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void delete(@EndpointParam URI var1);

    @Named(value="GlobalOperations:list")
    @GET
    @Endpoint(value=CurrentProject.class)
    @Path(value="/global/operations")
    public ListPage<Operation> listPage(@Nullable @QueryParam(value="pageToken") String var1, ListOptions var2);

    @Named(value="GlobalOperations:list")
    @GET
    @Endpoint(value=CurrentProject.class)
    @Path(value="/global/operations")
    @Transform(value=OperationPages.class)
    public Iterator<ListPage<Operation>> list();

    @Named(value="GlobalOperations:list")
    @GET
    @Endpoint(value=CurrentProject.class)
    @Path(value="/global/operations")
    @Transform(value=OperationPages.class)
    public Iterator<ListPage<Operation>> list(ListOptions var1);

    @Named(value="RegionOperations:list")
    @GET
    @Endpoint(value=CurrentProject.class)
    @Path(value="/regions/{region}/operations")
    public ListPage<Operation> listPageInRegion(@PathParam(value="region") String var1, @Nullable @QueryParam(value="pageToken") String var2, ListOptions var3);

    @Named(value="RegionOperations:list")
    @GET
    @Endpoint(value=CurrentProject.class)
    @Path(value="/regions/{region}/operations")
    @Transform(value=OperationPagesInRegion.class)
    public Iterator<ListPage<Operation>> listInRegion(@PathParam(value="region") String var1);

    @Named(value="RegionOperations:list")
    @GET
    @Endpoint(value=CurrentProject.class)
    @Path(value="/regions/{region}/operations")
    @Transform(value=OperationPagesInRegion.class)
    public Iterator<ListPage<Operation>> listInRegion(@PathParam(value="region") String var1, ListOptions var2);

    @Named(value="ZoneOperations:list")
    @GET
    @Endpoint(value=CurrentProject.class)
    @Path(value="/zones/{zone}/operations")
    public ListPage<Operation> listPageInZone(@PathParam(value="zone") String var1, @Nullable @QueryParam(value="pageToken") String var2, ListOptions var3);

    @Named(value="ZoneOperations:list")
    @GET
    @Endpoint(value=CurrentProject.class)
    @Path(value="/zones/{zone}/operations")
    @Transform(value=OperationPagesInZone.class)
    public Iterator<ListPage<Operation>> listInZone(@PathParam(value="zone") String var1);

    @Named(value="ZoneOperations:list")
    @GET
    @Endpoint(value=CurrentProject.class)
    @Path(value="/zones/{zone}/operations")
    @Transform(value=OperationPagesInZone.class)
    public Iterator<ListPage<Operation>> listInZone(@PathParam(value="zone") String var1, ListOptions var2);

    public static final class OperationPagesInZone
    extends BaseArg0ToIteratorOfListPage<Operation, OperationPagesInZone> {
        private final GoogleComputeEngineApi api;

        @Inject
        OperationPagesInZone(GoogleComputeEngineApi api) {
            this.api = api;
        }

        protected Function<String, ListPage<Operation>> fetchNextPage(final String zoneName, final ListOptions options) {
            return new Function<String, ListPage<Operation>>(){

                public ListPage<Operation> apply(String pageToken) {
                    return OperationPagesInZone.this.api.operations().listPageInZone(zoneName, pageToken, options);
                }
            };
        }
    }

    public static final class OperationPagesInRegion
    extends BaseArg0ToIteratorOfListPage<Operation, OperationPagesInRegion> {
        private final GoogleComputeEngineApi api;

        @Inject
        OperationPagesInRegion(GoogleComputeEngineApi api) {
            this.api = api;
        }

        protected Function<String, ListPage<Operation>> fetchNextPage(final String regionName, final ListOptions options) {
            return new Function<String, ListPage<Operation>>(){

                public ListPage<Operation> apply(String pageToken) {
                    return OperationPagesInRegion.this.api.operations().listPageInRegion(regionName, pageToken, options);
                }
            };
        }
    }

    public static final class OperationPages
    extends BaseToIteratorOfListPage<Operation, OperationPages> {
        private final GoogleComputeEngineApi api;

        @Inject
        OperationPages(GoogleComputeEngineApi api) {
            this.api = api;
        }

        protected Function<String, ListPage<Operation>> fetchNextPage(final ListOptions options) {
            return new Function<String, ListPage<Operation>>(){

                public ListPage<Operation> apply(String pageToken) {
                    return OperationPages.this.api.operations().listPage(pageToken, options);
                }
            };
        }
    }
}

