/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.joyent.cloudapi.v6_5.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import java.beans.ConstructorProperties;
import java.util.Date;

public class Key
implements Comparable<Key> {
    protected final String name;
    protected final String key;
    protected final transient Date created;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Key.builder().fromKey(this);
    }

    @ConstructorProperties(value={"name", "key", "created"})
    public Key(String name, String key, Date created) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.key = (String)Preconditions.checkNotNull((Object)key, (String)"key: OpenSSH formatted public key of key(%s)", (Object[])new Object[]{name});
        this.created = (Date)Preconditions.checkNotNull((Object)created, (String)"created date of key(%s)", (Object[])new Object[]{name});
    }

    public String getName() {
        return this.name;
    }

    public String get() {
        return this.key;
    }

    public Date getCreated() {
        return this.created;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Key) {
            Key that = (Key)Key.class.cast(object);
            return Objects.equal((Object)this.name, (Object)that.name);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name});
    }

    public String toString() {
        return Objects.toStringHelper((String)"").omitNullValues().add("name", (Object)this.name).add("key", (Object)this.key).add("created", (Object)this.created).toString();
    }

    @Override
    public int compareTo(Key that) {
        return ComparisonChain.start().compare((Comparable)((Object)this.name), (Comparable)((Object)that.name)).compare((Comparable)this.created, (Comparable)that.created).result();
    }

    public static class Builder {
        private String name;
        private String key;
        private Date created = new Date();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder created(Date created) {
            this.created = created;
            return this;
        }

        public Key build() {
            return new Key(this.name, this.key, this.created);
        }

        public Builder fromKey(Key in) {
            return this.name(in.getName()).key(in.get()).created(in.getCreated());
        }
    }
}

