/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.joyent.cloudapi.v6_5.domain;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import org.jclouds.domain.JsonBall;

public class Machine
implements Comparable<Machine> {
    protected final String id;
    protected final String name;
    protected final Type type;
    protected final State state;
    protected final String dataset;
    @Named(value="memory")
    protected final int memorySizeMb;
    @Named(value="disk")
    protected final int diskSizeGb;
    protected final Set<String> ips;
    protected final Date created;
    protected final Date updated;
    private final Map<String, JsonBall> metadata;
    @VisibleForTesting
    static final Function<JsonBall, String> unquoteString = new Function<JsonBall, String>(){

        public String apply(JsonBall input) {
            String value = input.toString();
            if (value.length() >= 2 && value.charAt(0) == '\"' && value.charAt(input.length() - 1) == '\"') {
                return value.substring(1, input.length() - 1);
            }
            return value;
        }
    };

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromMachine(this);
    }

    @ConstructorProperties(value={"id", "name", "type", "state", "dataset", "memory", "disk", "ips", "created", "updated", "metadata"})
    public Machine(String id, String name, Type type, State state, String dataset, int memorySizeMb, int diskSizeGb, Set<String> ips, Date created, Date updated, Map<String, JsonBall> metadata) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.name = (String)Preconditions.checkNotNull((Object)name, (String)"name of machine(%s)", (Object[])new Object[]{id});
        this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (String)"type of machine(%s)", (Object[])new Object[]{id}));
        this.state = (State)((Object)Preconditions.checkNotNull((Object)((Object)state), (String)"state of machine(%s)", (Object[])new Object[]{id}));
        this.dataset = (String)Preconditions.checkNotNull((Object)dataset, (String)"dataset of machine(%s)", (Object[])new Object[]{id});
        this.memorySizeMb = memorySizeMb;
        this.diskSizeGb = diskSizeGb;
        this.ips = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(ips, (String)"ips of machine(%s)", (Object[])new Object[]{id})));
        this.created = (Date)Preconditions.checkNotNull((Object)created, (String)"created date of machine(%s)", (Object[])new Object[]{id});
        this.updated = (Date)Preconditions.checkNotNull((Object)created, (String)"updated date of machine(%s)", (Object[])new Object[]{id});
        this.metadata = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(metadata, (String)"metadata of machine(%s)", (Object[])new Object[]{id})));
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public State getState() {
        return this.state;
    }

    public String getDatasetURN() {
        return this.dataset;
    }

    public int getMemorySizeMb() {
        return this.memorySizeMb;
    }

    public int getDiskSizeGb() {
        return this.diskSizeGb;
    }

    public Set<String> getIps() {
        return this.ips;
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public Map<String, String> getMetadataAsJsonLiterals() {
        return Maps.transformValues(this.metadata, (Function)Functions.toStringFunction());
    }

    public Map<String, String> getMetadata() {
        return Maps.transformValues(this.metadata, (Function)Functions.compose((Function)Functions.toStringFunction(), unquoteString));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Machine) {
            Machine that = (Machine)Machine.class.cast(object);
            return Objects.equal((Object)this.id, (Object)that.id);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }

    public String toString() {
        return Objects.toStringHelper((String)"").omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("type", (Object)this.type).add("state", (Object)this.state).add("memorySizeMb", this.memorySizeMb).add("diskSizeGb", this.diskSizeGb).add("ips", this.ips).add("created", (Object)this.created).add("updated", (Object)this.updated).toString();
    }

    @Override
    public int compareTo(Machine that) {
        return ComparisonChain.start().compare((Comparable)((Object)this.name), (Comparable)((Object)that.name)).compare((Comparable)this.created, (Comparable)that.created).compare((Comparable)((Object)this.id), (Comparable)((Object)that.id)).result();
    }

    public static class Builder {
        private String id;
        private String name;
        private Type type;
        private State state;
        private String dataset;
        private int memorySizeMb;
        private int diskSizeGb;
        private ImmutableSet.Builder<String> ips = ImmutableSet.builder();
        private Date created;
        private Date updated;
        private ImmutableMap.Builder<String, JsonBall> metadata = ImmutableMap.builder();

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder state(State state) {
            this.state = state;
            return this;
        }

        public Builder dataset(String dataset) {
            this.dataset = dataset;
            return this;
        }

        public Builder memorySizeMb(int memorySizeMb) {
            this.memorySizeMb = memorySizeMb;
            return this;
        }

        public Builder diskSizeGb(int diskSizeGb) {
            this.diskSizeGb = diskSizeGb;
            return this;
        }

        public Builder ips(Set<String> ips) {
            this.ips = ImmutableSet.builder();
            this.ips.addAll((Iterable)Preconditions.checkNotNull(ips, (Object)"ips"));
            return this;
        }

        public Builder addIp(String ip) {
            this.ips.add(Preconditions.checkNotNull((Object)ip, (Object)"ip"));
            return this;
        }

        public Builder created(Date created) {
            this.created = created;
            return this;
        }

        public Builder updated(Date updated) {
            this.updated = updated;
            return this;
        }

        public Builder metadata(Map<String, JsonBall> metadata) {
            this.metadata = ImmutableMap.builder();
            this.metadata.putAll((Map)Preconditions.checkNotNull(metadata, (Object)"metadata"));
            return this;
        }

        public Builder addMetadata(String name, JsonBall values) {
            this.metadata.put(Preconditions.checkNotNull((Object)name, (Object)"name"), Preconditions.checkNotNull((Object)values, (String)"value of %s", (Object[])new Object[]{name}));
            return this;
        }

        public Machine build() {
            return new Machine(this.id, this.name, this.type, this.state, this.dataset, this.memorySizeMb, this.diskSizeGb, (Set<String>)this.ips.build(), this.created, this.updated, (Map<String, JsonBall>)this.metadata.build());
        }

        public Builder fromMachine(Machine in) {
            return this.id(in.getId()).name(in.getName()).type(in.getType()).state(in.getState()).dataset(in.getDatasetURN()).memorySizeMb(in.getMemorySizeMb()).diskSizeGb(in.getDiskSizeGb()).ips(in.getIps()).metadata(in.metadata).created(in.getCreated()).updated(in.getUpdated());
        }
    }

    public static enum State {
        PROVISIONING,
        RUNNING,
        STOPPING,
        STOPPED,
        OFFLINE,
        DELETED,
        UNRECOGNIZED;


        public static State fromValue(String state) {
            try {
                return State.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, (String)Preconditions.checkNotNull((Object)state, (Object)"state")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }

        public String value() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }

        public String toString() {
            return this.value();
        }
    }

    public static enum Type {
        VIRTUALMACHINE,
        SMARTMACHINE,
        UNRECOGNIZED;


        public static Type fromValue(String type) {
            try {
                return Type.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, (String)Preconditions.checkNotNull((Object)type, (Object)"type")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }

        public String value() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }

        public String toString() {
            return this.value();
        }
    }
}

