/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.joyent.cloudapi.v6_5.domain.datacenterscoped;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;

public class DatacenterAndName {
    public static final Function<DatacenterAndName, String> NAME_FUNCTION = new Function<DatacenterAndName, String>(){

        public String apply(DatacenterAndName input) {
            return input.getName();
        }
    };
    public static final Function<DatacenterAndName, String> DATACENTER_FUNCTION = new Function<DatacenterAndName, String>(){

        public String apply(DatacenterAndName input) {
            return input.getDatacenter();
        }
    };
    protected final String datacenterId;
    protected final String name;

    public static DatacenterAndName fromSlashEncoded(String name) {
        Iterable parts = Splitter.on((char)'/').split((CharSequence)Preconditions.checkNotNull((Object)name, (Object)"name"));
        Preconditions.checkArgument((Iterables.size((Iterable)parts) == 2 ? 1 : 0) != 0, (Object)"name must be in format datacenterId/name");
        return new DatacenterAndName((String)Iterables.get((Iterable)parts, (int)0), (String)Iterables.get((Iterable)parts, (int)1));
    }

    public static DatacenterAndName fromDatacenterAndName(String datacenterId, String name) {
        return new DatacenterAndName(datacenterId, name);
    }

    private static String slashEncodeDatacenterAndName(String datacenterId, String name) {
        return (String)Preconditions.checkNotNull((Object)datacenterId, (Object)"datacenterId") + "/" + (String)Preconditions.checkNotNull((Object)name, (Object)"name");
    }

    public String slashEncode() {
        return DatacenterAndName.slashEncodeDatacenterAndName(this.datacenterId, this.name);
    }

    protected DatacenterAndName(String datacenterId, String name) {
        this.datacenterId = (String)Preconditions.checkNotNull((Object)datacenterId, (Object)"datacenterId");
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
    }

    public String getDatacenter() {
        return this.datacenterId;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatacenterAndName that = (DatacenterAndName)DatacenterAndName.class.cast(o);
        return Objects.equal((Object)this.datacenterId, (Object)that.datacenterId) && Objects.equal((Object)this.name, (Object)that.name);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.datacenterId, this.name});
    }

    public String toString() {
        return this.string().toString();
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").add("datacenterId", (Object)this.datacenterId).add("name", (Object)this.name);
    }
}

