/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.joyent.cloudapi.v6_5.compute.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.config.ComputeServiceAdapterContextModule;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.strategy.impl.CreateNodesWithGroupEncodedIntoNameThenAddToSet;
import org.jclouds.domain.Location;
import org.jclouds.functions.IdentityFunction;
import org.jclouds.joyent.cloudapi.v6_5.compute.JoyentCloudComputeService;
import org.jclouds.joyent.cloudapi.v6_5.compute.JoyentCloudComputeServiceAdapter;
import org.jclouds.joyent.cloudapi.v6_5.compute.functions.DatasetInDatacenterToImage;
import org.jclouds.joyent.cloudapi.v6_5.compute.functions.DatasetToOperatingSystem;
import org.jclouds.joyent.cloudapi.v6_5.compute.functions.MachineInDatacenterToNodeMetadata;
import org.jclouds.joyent.cloudapi.v6_5.compute.functions.OrphanedGroupsByDatacenterId;
import org.jclouds.joyent.cloudapi.v6_5.compute.functions.PackageInDatacenterToHardware;
import org.jclouds.joyent.cloudapi.v6_5.compute.internal.KeyAndPrivateKey;
import org.jclouds.joyent.cloudapi.v6_5.compute.loaders.CreateUniqueKey;
import org.jclouds.joyent.cloudapi.v6_5.compute.options.JoyentCloudTemplateOptions;
import org.jclouds.joyent.cloudapi.v6_5.compute.strategy.ApplyJoyentCloudTemplateOptionsCreateNodesWithGroupEncodedIntoNameThenAddToSet;
import org.jclouds.joyent.cloudapi.v6_5.domain.Dataset;
import org.jclouds.joyent.cloudapi.v6_5.domain.Machine;
import org.jclouds.joyent.cloudapi.v6_5.domain.datacenterscoped.DatacenterAndName;
import org.jclouds.joyent.cloudapi.v6_5.domain.datacenterscoped.DatasetInDatacenter;
import org.jclouds.joyent.cloudapi.v6_5.domain.datacenterscoped.MachineInDatacenter;
import org.jclouds.joyent.cloudapi.v6_5.domain.datacenterscoped.PackageInDatacenter;

public class JoyentCloudComputeServiceContextModule
extends ComputeServiceAdapterContextModule<MachineInDatacenter, PackageInDatacenter, DatasetInDatacenter, Location> {
    @VisibleForTesting
    public static final Map<Machine.State, NodeMetadata.Status> toPortableNodeStatus = ImmutableMap.builder().put((Object)Machine.State.PROVISIONING, (Object)NodeMetadata.Status.PENDING).put((Object)Machine.State.RUNNING, (Object)NodeMetadata.Status.RUNNING).put((Object)Machine.State.STOPPING, (Object)NodeMetadata.Status.PENDING).put((Object)Machine.State.OFFLINE, (Object)NodeMetadata.Status.PENDING).put((Object)Machine.State.STOPPED, (Object)NodeMetadata.Status.SUSPENDED).put((Object)Machine.State.DELETED, (Object)NodeMetadata.Status.TERMINATED).put((Object)Machine.State.UNRECOGNIZED, (Object)NodeMetadata.Status.UNRECOGNIZED).build();

    protected void configure() {
        super.configure();
        this.bind((TypeLiteral)new TypeLiteral<ComputeServiceAdapter<MachineInDatacenter, PackageInDatacenter, DatasetInDatacenter, Location>>(){}).to(JoyentCloudComputeServiceAdapter.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<MachineInDatacenter, NodeMetadata>>(){}).to(MachineInDatacenterToNodeMetadata.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<DatasetInDatacenter, Image>>(){}).to(DatasetInDatacenterToImage.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Dataset, OperatingSystem>>(){}).to(DatasetToOperatingSystem.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<PackageInDatacenter, Hardware>>(){}).to(PackageInDatacenterToHardware.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Location, Location>>(){}).to((Class)Class.class.cast(IdentityFunction.class));
        this.bind((TypeLiteral)new TypeLiteral<Function<Set<? extends NodeMetadata>, Multimap<String, String>>>(){}).to(OrphanedGroupsByDatacenterId.class);
        this.bind(ComputeService.class).to(JoyentCloudComputeService.class);
        this.bind(TemplateOptions.class).to(JoyentCloudTemplateOptions.class);
        this.bind(CreateNodesWithGroupEncodedIntoNameThenAddToSet.class).to(ApplyJoyentCloudTemplateOptionsCreateNodesWithGroupEncodedIntoNameThenAddToSet.class);
        this.bind((TypeLiteral)new TypeLiteral<CacheLoader<DatacenterAndName, KeyAndPrivateKey>>(){}).to(CreateUniqueKey.class);
    }

    protected TemplateOptions provideTemplateOptions(Injector injector, TemplateOptions options) {
        boolean generateKey = (Boolean)injector.getInstance(Key.get(Boolean.TYPE, (Annotation)Names.named((String)"jclouds.joyent-cloudapi.autogenerate-keys")));
        return ((JoyentCloudTemplateOptions)options.as(JoyentCloudTemplateOptions.class)).generateKey(generateKey);
    }

    @Provides
    @Singleton
    protected LoadingCache<DatacenterAndName, KeyAndPrivateKey> keyMap(CacheLoader<DatacenterAndName, KeyAndPrivateKey> in) {
        return CacheBuilder.newBuilder().build(in);
    }

    @Provides
    @Singleton
    protected Supplier<Map<String, Location>> createLocationIndexedById(@Memoized Supplier<Set<? extends Location>> locations) {
        return Suppliers.compose((Function)new Function<Set<? extends Location>, Map<String, Location>>(){

            public Map<String, Location> apply(Set<? extends Location> arg0) {
                return Maps.uniqueIndex((Iterable)ImmutableSet.copyOf(arg0), (Function)new Function<Location, String>(){

                    public String apply(Location arg0) {
                        return arg0.getId();
                    }
                });
            }
        }, locations);
    }

    @Singleton
    @Provides
    protected Map<Machine.State, NodeMetadata.Status> toPortableNodeStatus() {
        return toPortableNodeStatus;
    }
}

