/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.joyent.cloudapi.v6_5.compute.functions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.predicates.NodePredicates;
import org.jclouds.joyent.cloudapi.v6_5.compute.predicates.AllNodesInGroupTerminated;
import org.jclouds.joyent.cloudapi.v6_5.domain.datacenterscoped.DatacenterAndName;

public class OrphanedGroupsByDatacenterId
implements Function<Set<? extends NodeMetadata>, Multimap<String, String>> {
    private final Predicate<DatacenterAndName> allNodesInGroupTerminated;

    @Inject
    protected OrphanedGroupsByDatacenterId(ComputeService computeService) {
        this(new AllNodesInGroupTerminated((ComputeService)Preconditions.checkNotNull((Object)computeService, (Object)"computeService")));
    }

    @VisibleForTesting
    OrphanedGroupsByDatacenterId(Predicate<DatacenterAndName> allNodesInGroupTerminated) {
        this.allNodesInGroupTerminated = (Predicate)Preconditions.checkNotNull(allNodesInGroupTerminated, (Object)"allNodesInGroupTerminated");
    }

    public Multimap<String, String> apply(Set<? extends NodeMetadata> deadNodes) {
        Iterable nodesWithGroup = Iterables.filter(deadNodes, (Predicate)NodePredicates.hasGroup());
        ImmutableSet datacenterAndGroupNames = ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)nodesWithGroup, (Function)new Function<NodeMetadata, DatacenterAndName>(){

            public DatacenterAndName apply(NodeMetadata input) {
                String datacenterId = input.getLocation().getId();
                return DatacenterAndName.fromDatacenterAndName(datacenterId, input.getGroup());
            }
        }), this.allNodesInGroupTerminated));
        ListMultimap datacenterToDatacenterAndGroupNames = Multimaps.transformValues((ListMultimap)Multimaps.index((Iterable)datacenterAndGroupNames, DatacenterAndName.DATACENTER_FUNCTION), DatacenterAndName.NAME_FUNCTION);
        return datacenterToDatacenterAndGroupNames;
    }
}

