/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.joyent.cloudapi.v6_5.compute.loaders;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheLoader;
import com.google.inject.Inject;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.joyent.cloudapi.v6_5.JoyentCloudApi;
import org.jclouds.joyent.cloudapi.v6_5.compute.internal.KeyAndPrivateKey;
import org.jclouds.joyent.cloudapi.v6_5.domain.Key;
import org.jclouds.joyent.cloudapi.v6_5.domain.datacenterscoped.DatacenterAndName;
import org.jclouds.logging.Logger;
import org.jclouds.ssh.SshKeyPairGenerator;

@Singleton
public class CreateUniqueKey
extends CacheLoader<DatacenterAndName, KeyAndPrivateKey> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final JoyentCloudApi cloudApiApi;
    protected final GroupNamingConvention.Factory namingConvention;
    protected final SshKeyPairGenerator sshKeyPairGenerator;

    @Inject
    public CreateUniqueKey(JoyentCloudApi cloudApiApi, GroupNamingConvention.Factory namingConvention, SshKeyPairGenerator sshKeyPairGenerator) {
        this.cloudApiApi = (JoyentCloudApi)Preconditions.checkNotNull((Object)cloudApiApi, (Object)"cloudApiApi");
        this.namingConvention = (GroupNamingConvention.Factory)Preconditions.checkNotNull((Object)namingConvention, (Object)"namingConvention");
        this.sshKeyPairGenerator = (SshKeyPairGenerator)Preconditions.checkNotNull((Object)sshKeyPairGenerator, (Object)"sshKeyPairGenerator");
    }

    public KeyAndPrivateKey load(DatacenterAndName datacenterAndName) {
        String datacenterId = ((DatacenterAndName)Preconditions.checkNotNull((Object)datacenterAndName, (Object)"datacenterAndName")).getDatacenter();
        String prefix = datacenterAndName.getName();
        Map keyPair = (Map)this.sshKeyPairGenerator.get();
        String publicKey = (String)keyPair.get("public");
        String privateKey = (String)keyPair.get("private");
        this.logger.debug(">> creating key datacenter(%s) prefix(%s)", new Object[]{datacenterId, prefix});
        Key key = null;
        while (key == null) {
            String name = this.namingConvention.createWithoutPrefix().uniqueNameForGroup(prefix);
            try {
                key = this.cloudApiApi.getKeyApi().create(Key.builder().name(name).key(publicKey).build());
            }
            catch (IllegalStateException e) {
                this.logger.trace("error creating keypair named %s, %s", new Object[]{name, e.getMessage()});
            }
        }
        this.logger.debug("<< created key(%s)", new Object[]{key.getName()});
        return KeyAndPrivateKey.fromKeyAndPrivateKey(key, privateKey);
    }
}

