/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.joyent.cloudapi.v6_5.compute.strategy;

import com.google.common.base.Preconditions;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.config.CustomizationResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.strategy.CreateNodeWithGroupEncodedIntoName;
import org.jclouds.compute.strategy.CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.compute.strategy.impl.CreateNodesWithGroupEncodedIntoNameThenAddToSet;
import org.jclouds.joyent.cloudapi.v6_5.compute.internal.KeyAndPrivateKey;
import org.jclouds.joyent.cloudapi.v6_5.compute.options.JoyentCloudTemplateOptions;
import org.jclouds.joyent.cloudapi.v6_5.domain.datacenterscoped.DatacenterAndName;

@Singleton
public class ApplyJoyentCloudTemplateOptionsCreateNodesWithGroupEncodedIntoNameThenAddToSet
extends CreateNodesWithGroupEncodedIntoNameThenAddToSet {
    private final LoadingCache<DatacenterAndName, KeyAndPrivateKey> keyCache;
    private final boolean defaultToAutogenerateKeys;

    @Inject
    protected ApplyJoyentCloudTemplateOptionsCreateNodesWithGroupEncodedIntoNameThenAddToSet(CreateNodeWithGroupEncodedIntoName addNodeWithTagStrategy, ListNodesStrategy listNodesStrategy, GroupNamingConvention.Factory namingConvention, CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap.Factory customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, LoadingCache<DatacenterAndName, KeyAndPrivateKey> keyCache, @Named(value="jclouds.joyent-cloudapi.autogenerate-keys") boolean defaultToAutogenerateKeys) {
        super(addNodeWithTagStrategy, listNodesStrategy, namingConvention, userExecutor, customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory);
        this.keyCache = (LoadingCache)Preconditions.checkNotNull(keyCache, (Object)"keyCache");
        this.defaultToAutogenerateKeys = defaultToAutogenerateKeys;
    }

    public Map<?, ListenableFuture<Void>> execute(String group, int count, Template template, Set<NodeMetadata> goodNodes, Map<NodeMetadata, Exception> badNodes, Multimap<NodeMetadata, CustomizationResponse> customizationResponses) {
        Template mutableTemplate = template.clone();
        JoyentCloudTemplateOptions templateOptions = (JoyentCloudTemplateOptions)JoyentCloudTemplateOptions.class.cast(mutableTemplate.getOptions());
        assert (template.getOptions().equals((Object)templateOptions)) : "options didn't clone properly";
        templateOptions.userMetadata("jclouds-group", group);
        String datacenter = mutableTemplate.getLocation().getId();
        if (!templateOptions.shouldGenerateKey().isPresent()) {
            templateOptions.generateKey(this.defaultToAutogenerateKeys);
        }
        if (((Boolean)templateOptions.shouldGenerateKey().get()).booleanValue()) {
            KeyAndPrivateKey keyPair = (KeyAndPrivateKey)this.keyCache.getUnchecked((Object)DatacenterAndName.fromDatacenterAndName(datacenter, this.namingConvention.create().sharedNameForGroup(group)));
            this.keyCache.asMap().put(DatacenterAndName.fromDatacenterAndName(datacenter, keyPair.getKey().getName()), keyPair);
            templateOptions.overrideLoginPrivateKey(keyPair.getPrivateKey());
        }
        Preconditions.checkArgument((templateOptions.getRunScript() == null || templateOptions.getLoginPrivateKey() != null ? 1 : 0) != 0, (Object)"when specifying runScript, you must either set overrideLoginPrivateKey, or generateKey(true)");
        return super.execute(group, count, mutableTemplate, goodNodes, badNodes, customizationResponses);
    }
}

