/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.oauth.v2.config;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.net.URI;
import java.security.PrivateKey;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.oauth.v2.AuthorizationApi;
import org.jclouds.oauth.v2.config.Authorization;
import org.jclouds.oauth.v2.config.CredentialType;
import org.jclouds.oauth.v2.config.PrivateKeySupplier;
import org.jclouds.oauth.v2.filters.BearerTokenFromCredentials;
import org.jclouds.oauth.v2.filters.JWTBearerTokenFlow;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.config.BinderUtils;

public final class OAuthModule
extends AbstractModule {
    protected void configure() {
        BinderUtils.bindHttpApi((Binder)this.binder(), AuthorizationApi.class);
        this.bind(CredentialType.class).toProvider(CredentialTypeFromPropertyOrDefault.class);
        this.bind((TypeLiteral)new TypeLiteral<Supplier<PrivateKey>>(){}).annotatedWith(Authorization.class).to(PrivateKeySupplier.class);
    }

    @Provides
    @Authorization
    protected Supplier<URI> oauthEndpoint(@Named(value="oauth.endpoint") String endpoint) {
        return Suppliers.ofInstance((Object)URI.create(endpoint));
    }

    @Provides
    @Singleton
    protected OAuthFilter authenticationFilterForCredentialType(CredentialType credentialType, JWTBearerTokenFlow serviceAccountAuth, BearerTokenFromCredentials bearerTokenAuth) {
        switch (credentialType) {
            case P12_PRIVATE_KEY_CREDENTIALS: {
                return serviceAccountAuth;
            }
            case BEARER_TOKEN_CREDENTIALS: {
                return bearerTokenAuth;
            }
        }
        throw new IllegalArgumentException("Unsupported credential type: " + (Object)((Object)credentialType));
    }

    @Singleton
    public static class CredentialTypeFromPropertyOrDefault
    implements Provider<CredentialType> {
        @Inject(optional=true)
        @Named(value="jclouds.oauth.credential-type")
        String credentialType = CredentialType.P12_PRIVATE_KEY_CREDENTIALS.toString();

        public CredentialType get() {
            return CredentialType.fromValue(this.credentialType);
        }
    }
}

