/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.glance.v1_0.functions.internal;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.inject.TypeLiteral;
import java.beans.ConstructorProperties;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.IterableWithMarkers;
import org.jclouds.collect.internal.Arg0ToPagedIterable;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.Json;
import org.jclouds.openstack.glance.v1_0.GlanceApi;
import org.jclouds.openstack.glance.v1_0.domain.Image;
import org.jclouds.openstack.glance.v1_0.features.ImageApi;
import org.jclouds.openstack.glance.v1_0.options.ListImageOptions;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.domain.PaginatedCollection;
import org.jclouds.openstack.v2_0.options.PaginationOptions;

@Singleton
@Beta
public class ParseImages
extends ParseJson<Images> {
    @Inject
    public ParseImages(Json json) {
        super(json, TypeLiteral.get(Images.class));
    }

    public static class ToPagedIterable
    extends Arg0ToPagedIterable.FromCaller<Image, ToPagedIterable> {
        private final GlanceApi api;

        @Inject
        protected ToPagedIterable(GlanceApi api) {
            this.api = (GlanceApi)Preconditions.checkNotNull((Object)api, (Object)"api");
        }

        protected Function<Object, IterableWithMarker<Image>> markerToNextForArg0(Optional<Object> arg0) {
            String region = arg0.isPresent() ? arg0.get().toString() : null;
            final ImageApi imageApi = this.api.getImageApi(region);
            return new Function<Object, IterableWithMarker<Image>>(){

                public IterableWithMarker<Image> apply(Object input) {
                    PaginationOptions paginationOptions = (PaginationOptions)PaginationOptions.class.cast(input);
                    Collection markers = paginationOptions.buildQueryParameters().get((Object)"marker");
                    if (!markers.isEmpty()) {
                        return (IterableWithMarker)IterableWithMarker.class.cast(imageApi.listInDetail(ListImageOptions.Builder.marker((String)Iterables.getOnlyElement((Iterable)markers))));
                    }
                    return IterableWithMarkers.EMPTY;
                }

                public String toString() {
                    return "list()";
                }
            };
        }
    }

    static class Images
    extends PaginatedCollection<Image> {
        @ConstructorProperties(value={"images", "images_links"})
        protected Images(Iterable<Image> images, Iterable<Link> images_links) {
            super(images, images_links);
        }
    }
}

