/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.marconi.v1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.Date;
import javax.inject.Named;

public class Aged {
    private final int age;
    private final Date created;
    @Named(value="href")
    private final String id;

    @ConstructorProperties(value={"age", "created", "href"})
    protected Aged(int age, Date created, String id) {
        this.age = age;
        this.created = (Date)Preconditions.checkNotNull((Object)created, (Object)"created required");
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id required");
    }

    public int getAge() {
        return this.age;
    }

    public Date getCreated() {
        return this.created;
    }

    public String getId() {
        return this.id;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.age, this.created, this.id});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Aged that = (Aged)Aged.class.cast(obj);
        return Objects.equal((Object)this.age, (Object)that.age) && Objects.equal((Object)this.created, (Object)that.created) && Objects.equal((Object)this.id, (Object)that.id);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("age", this.age).add("created", (Object)this.created).add("id", (Object)this.id);
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new ConcreteBuilder();
    }

    public Builder toBuilder() {
        return new ConcreteBuilder().fromAged(this);
    }

    private static class ConcreteBuilder
    extends Builder {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder {
        protected int age;
        protected Date created;
        protected String id;

        protected abstract Builder self();

        public Builder age(int age) {
            this.age = age;
            return this.self();
        }

        public Builder created(Date created) {
            this.created = created;
            return this.self();
        }

        public Builder id(String id) {
            this.id = id;
            return this.self();
        }

        public Aged build() {
            return new Aged(this.age, this.created, this.id);
        }

        public Builder fromAged(Aged in) {
            return this.age(in.getAge()).created(in.getCreated()).id(in.getId());
        }
    }
}

