/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.marconi.v1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.jclouds.domain.JsonBall;

public class CreateMessage {
    private int ttl;
    private String body;

    protected CreateMessage(int ttl, String body) {
        this.ttl = ttl;
        this.body = (String)Preconditions.checkNotNull((Object)body, (Object)"body required");
    }

    public int getTTL() {
        return this.ttl;
    }

    public String getBody() {
        return this.body;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.ttl, this.body});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateMessage that = (CreateMessage)CreateMessage.class.cast(obj);
        return Objects.equal((Object)this.ttl, (Object)that.ttl) && Objects.equal((Object)this.body, (Object)that.body);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("ttl", this.ttl).add("body", (Object)this.body);
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new ConcreteBuilder();
    }

    public Builder toBuilder() {
        return new ConcreteBuilder().fromMessage(this);
    }

    private static class ConcreteBuilder
    extends Builder {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder {
        protected int ttl;
        protected String body;

        protected abstract Builder self();

        public Builder ttl(int ttl) {
            this.ttl = ttl;
            return this.self();
        }

        public Builder body(String json) {
            Preconditions.checkNotNull((Object)json, (Object)"body required");
            this.body = new JsonBall(json).toString();
            return this.self();
        }

        public CreateMessage build() {
            return new CreateMessage(this.ttl, this.body);
        }

        public Builder fromMessage(CreateMessage in) {
            return this.ttl(in.getTTL()).body(in.getBody());
        }
    }
}

