/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.marconi.v1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.jclouds.javax.annotation.Nullable;

public class Message {
    private final String id;
    private final int ttl;
    private final String body;
    private final int age;
    private final String claimId;

    protected Message(String id, int ttl, String body, int age, @Nullable String claimId) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id required");
        this.ttl = ttl;
        this.body = (String)Preconditions.checkNotNull((Object)body, (Object)"body required");
        this.age = age;
        this.claimId = claimId;
    }

    public String getId() {
        return this.id;
    }

    public int getTTL() {
        return this.ttl;
    }

    public String getBody() {
        return this.body;
    }

    public int getAge() {
        return this.age;
    }

    public Optional<String> getClaimId() {
        return Optional.fromNullable((Object)this.claimId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Message that = (Message)Message.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("ttl", this.ttl).add("body", (Object)this.body).add("age", this.age).add("claimId", (Object)this.claimId);
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new ConcreteBuilder();
    }

    public Builder toBuilder() {
        return new ConcreteBuilder().fromMessage(this);
    }

    private static class ConcreteBuilder
    extends Builder {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder {
        protected String id;
        protected int ttl;
        protected String body;
        protected int age;
        protected String claimId;

        protected abstract Builder self();

        public Builder id(String id) {
            this.id = id;
            return this.self();
        }

        public Builder ttl(int ttl) {
            this.ttl = ttl;
            return this.self();
        }

        public Builder body(String json) {
            this.body = json;
            return this.self();
        }

        public Builder age(int age) {
            this.age = age;
            return this.self();
        }

        public Builder claimId(String claimId) {
            this.claimId = claimId;
            return this.self();
        }

        public Message build() {
            return new Message(this.id, this.ttl, this.body, this.age, this.claimId);
        }

        public Builder fromMessage(Message in) {
            return this.id(in.getId()).ttl(in.getTTL()).body(in.getBody()).age(in.getAge()).claimId((String)in.getClaimId().orNull());
        }
    }
}

