/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.marconi.v1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.List;
import javax.inject.Named;

public class MessagesCreated {
    @Named(value="resources")
    private final List<String> messageIds;

    @ConstructorProperties(value={"resources"})
    protected MessagesCreated(List<String> messageIds) {
        this.messageIds = (List)Preconditions.checkNotNull(messageIds, (Object)"messageIds required");
    }

    public List<String> getMessageIds() {
        return this.messageIds;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.messageIds});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MessagesCreated that = (MessagesCreated)MessagesCreated.class.cast(obj);
        return Objects.equal(this.messageIds, that.messageIds);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("messageIds", this.messageIds);
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new ConcreteBuilder();
    }

    public Builder toBuilder() {
        return new ConcreteBuilder().fromMessageCreated(this);
    }

    private static class ConcreteBuilder
    extends Builder {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder {
        protected List<String> messageIds;

        protected abstract Builder self();

        public Builder messageIds(List<String> messageIds) {
            this.messageIds = messageIds;
            return this.self();
        }

        public MessagesCreated build() {
            return new MessagesCreated(this.messageIds);
        }

        public Builder fromMessageCreated(MessagesCreated in) {
            return this.messageIds(in.getMessageIds());
        }
    }
}

