/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.marconi.v1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.jclouds.openstack.marconi.v1.domain.MessagesStats;

public class QueueStats {
    private final MessagesStats messages;

    protected QueueStats(MessagesStats messageStats) {
        this.messages = (MessagesStats)Preconditions.checkNotNull((Object)messageStats, (Object)"messageStats required");
    }

    public MessagesStats getMessagesStats() {
        return this.messages;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.messages});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QueueStats that = (QueueStats)QueueStats.class.cast(obj);
        return Objects.equal((Object)this.messages, (Object)that.messages);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("messagesStats", (Object)this.messages);
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new ConcreteBuilder();
    }

    public Builder toBuilder() {
        return new ConcreteBuilder().fromQueueStats(this);
    }

    private static class ConcreteBuilder
    extends Builder {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder {
        protected MessagesStats messagesStats;

        protected abstract Builder self();

        public Builder messageStats(MessagesStats messagesStats) {
            this.messagesStats = messagesStats;
            return this.self();
        }

        public QueueStats build() {
            return new QueueStats(this.messagesStats);
        }

        public Builder fromQueueStats(QueueStats in) {
            return this.messageStats(in.getMessagesStats());
        }
    }
}

