/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.marconi.v1.features;

import java.util.Map;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.collect.PagedIterable;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.marconi.v1.domain.Queue;
import org.jclouds.openstack.marconi.v1.domain.QueueStats;
import org.jclouds.openstack.marconi.v1.domain.Queues;
import org.jclouds.openstack.marconi.v1.fallbacks.EmptyQueuesFallback;
import org.jclouds.openstack.marconi.v1.functions.ParseQueueStats;
import org.jclouds.openstack.marconi.v1.functions.ParseQueues;
import org.jclouds.openstack.marconi.v1.functions.QueuesToPagedIterable;
import org.jclouds.openstack.marconi.v1.options.ListQueuesOptions;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.binders.BindToJsonPayload;

@SkipEncoding(value={47, 61})
@RequestFilters(value={AuthenticateRequest.class})
@Consumes(value={"application/json"})
@Path(value="/queues")
public interface QueueApi {
    @Named(value="queue:create")
    @PUT
    @Path(value="/{name}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean create(@PathParam(value="name") String var1);

    @Named(value="queue:delete")
    @DELETE
    @Path(value="/{name}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean delete(@PathParam(value="name") String var1);

    @Named(value="queue:get")
    @GET
    @Path(value="/{name}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean exists(@PathParam(value="name") String var1);

    @Named(value="queue:list")
    @GET
    @ResponseParser(value=ParseQueues.class)
    @Transform(value=QueuesToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Queue> list(@QueryParam(value="detailed") boolean var1);

    @Named(value="queue:list")
    @GET
    @ResponseParser(value=ParseQueues.class)
    @Fallback(value=EmptyQueuesFallback.class)
    public Queues list(ListQueuesOptions var1);

    @Named(value="queue:setMetadata")
    @PUT
    @Path(value="/{name}/metadata")
    @Produces(value={"application/json"})
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean setMetadata(@PathParam(value="name") String var1, @BinderParam(value=BindToJsonPayload.class) Map<String, String> var2);

    @Named(value="queue:getMetadata")
    @GET
    @Path(value="/{name}/metadata")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public Map<String, String> getMetadata(@PathParam(value="name") String var1);

    @Named(value="queue:getStats")
    @GET
    @Path(value="/{name}/stats")
    @ResponseParser(value=ParseQueueStats.class)
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public QueueStats getStats(@PathParam(value="name") String var1);
}

