/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.marconi.v1.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.List;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.openstack.marconi.v1.domain.MessagesCreated;
import org.jclouds.openstack.marconi.v1.functions.ParseMessagesToStream;

public class ParseMessagesCreated
implements Function<HttpResponse, MessagesCreated> {
    private final ParseJson<MessagesCreated> json;

    @Inject
    ParseMessagesCreated(ParseJson<MessagesCreated> json) {
        this.json = (ParseJson)Preconditions.checkNotNull(json, (Object)"json");
    }

    public MessagesCreated apply(HttpResponse from) {
        MessagesCreated rawMessagesCreated = (MessagesCreated)this.json.apply(from);
        List messageIds = Lists.transform(rawMessagesCreated.getMessageIds(), ParseMessagesToStream.TO_ID_FROM_HREF);
        MessagesCreated messagesCreated = MessagesCreated.builder().messageIds(messageIds).build();
        return messagesCreated;
    }
}

