/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.marconi.v1.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.net.URISyntaxException;
import javax.inject.Inject;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.http.utils.Queries;
import org.jclouds.openstack.marconi.v1.domain.Message;
import org.jclouds.openstack.marconi.v1.domain.MessageStream;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.domain.PaginatedCollection;

public class ParseMessagesToStream
implements Function<HttpResponse, MessageStream> {
    private final ParseJson<MessagesWithHref> json;
    protected static final Function<MessageWithHref, Message> TO_MESSAGE = new Function<MessageWithHref, Message>(){

        public Message apply(MessageWithHref messageWithHref) {
            return messageWithHref.toBuilder().id(ParseMessagesToStream.getIdFromHref(messageWithHref.getId())).claimId(ParseMessagesToStream.getClaimIdFromHref(messageWithHref.getId())).build();
        }
    };
    protected static final Function<String, String> TO_ID_FROM_HREF = new Function<String, String>(){

        public String apply(String messageIdWithHref) {
            return ParseMessagesToStream.getIdFromHref(messageIdWithHref);
        }
    };

    @Inject
    ParseMessagesToStream(ParseJson<MessagesWithHref> json) {
        this.json = (ParseJson)Preconditions.checkNotNull(json, (Object)"json");
    }

    public MessageStream apply(HttpResponse response) {
        if (response.getStatusCode() == 204) {
            return new Messages((Iterable<Message>)ImmutableSet.of(), (Iterable<Link>)ImmutableSet.of());
        }
        MessagesWithHref messagesWithHref = (MessagesWithHref)((Object)this.json.apply(response));
        Iterable messages = Iterables.transform((Iterable)((Object)messagesWithHref), TO_MESSAGE);
        return new Messages(messages, messagesWithHref.getLinks());
    }

    private static String getIdFromHref(String rawMessageHref) {
        int lastIndexOfSlash;
        int indexOfQuestionMark = rawMessageHref.indexOf(63);
        if (indexOfQuestionMark > (lastIndexOfSlash = rawMessageHref.lastIndexOf(47) + 1)) {
            return rawMessageHref.substring(lastIndexOfSlash, indexOfQuestionMark);
        }
        return rawMessageHref.substring(lastIndexOfSlash);
    }

    private static String getClaimIdFromHref(String rawMessageHref) {
        try {
            String query = new URI(rawMessageHref).getQuery();
            if (query != null) {
                Multimap queryParams = (Multimap)Queries.queryParser().apply((Object)query);
                return (String)Iterables.getOnlyElement((Iterable)queryParams.get((Object)"claim_id"), null);
            }
            return null;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    protected static class MessageWithHref
    extends Message {
        @ConstructorProperties(value={"href", "ttl", "body", "age"})
        protected MessageWithHref(String href, int ttl, String body, int age) {
            super(href, ttl, body, age, null);
        }
    }

    private static class MessagesWithHref
    extends PaginatedCollection<MessageWithHref> {
        @ConstructorProperties(value={"messages", "links"})
        protected MessagesWithHref(Iterable<MessageWithHref> messagesWithHref, Iterable<Link> links) {
            super(messagesWithHref, links);
        }
    }

    private static class Messages
    extends MessageStream {
        @ConstructorProperties(value={"messages", "links"})
        protected Messages(Iterable<Message> messages, Iterable<Link> links) {
            super(messages, links);
        }
    }
}

