/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.marconi.v1.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.openstack.marconi.v1.domain.Queue;
import org.jclouds.openstack.marconi.v1.domain.Queues;
import org.jclouds.openstack.v2_0.domain.PaginatedCollection;

public class ParseQueues
implements Function<HttpResponse, PaginatedCollection<Queue>> {
    private final ParseJson<Queues> json;

    @Inject
    ParseQueues(ParseJson<Queues> json) {
        this.json = (ParseJson)Preconditions.checkNotNull(json, (Object)"json");
    }

    public PaginatedCollection<Queue> apply(HttpResponse response) {
        if (response.getStatusCode() == 204) {
            return Queues.EMPTY;
        }
        return (PaginatedCollection)this.json.apply(response);
    }
}

