/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.marconi.v1.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import org.jclouds.openstack.v2_0.options.PaginationOptions;

public class StreamMessagesOptions
extends PaginationOptions {
    public static final StreamMessagesOptions NONE = new StreamMessagesOptions();

    public StreamMessagesOptions queryParameters(Multimap<String, String> queryParams) {
        Preconditions.checkNotNull(queryParams, (Object)"queryParams");
        this.queryParameters.putAll(queryParams);
        return this;
    }

    public StreamMessagesOptions marker(String marker) {
        super.marker(marker);
        return this;
    }

    public StreamMessagesOptions limit(int limit) {
        super.limit(limit);
        return this;
    }

    public StreamMessagesOptions echo(boolean echo) {
        this.queryParameters.put((Object)"echo", (Object)Boolean.toString(echo));
        return this;
    }

    public StreamMessagesOptions includeClaimed(boolean includeClaimed) {
        this.queryParameters.put((Object)"include_claimed", (Object)Boolean.toString(includeClaimed));
        return this;
    }

    public String getMarker() {
        return (String)Iterables.getOnlyElement((Iterable)this.queryParameters.get((Object)"marker"));
    }

    public static class Builder {
        public static StreamMessagesOptions queryParameters(Multimap<String, String> queryParams) {
            StreamMessagesOptions options = new StreamMessagesOptions();
            return options.queryParameters((Multimap)queryParams);
        }

        public static StreamMessagesOptions marker(String marker) {
            StreamMessagesOptions options = new StreamMessagesOptions();
            return options.marker(marker);
        }

        public static StreamMessagesOptions limit(int limit) {
            StreamMessagesOptions options = new StreamMessagesOptions();
            return options.limit(limit);
        }

        public static StreamMessagesOptions echo(boolean echo) {
            StreamMessagesOptions options = new StreamMessagesOptions();
            return options.echo(echo);
        }

        public static StreamMessagesOptions includeClaimed(boolean includeClaimed) {
            StreamMessagesOptions options = new StreamMessagesOptions();
            return options.echo(includeClaimed);
        }
    }
}

