/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.marconi.v1;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.http.okhttp.config.OkHttpCommandExecutorServiceModule;
import org.jclouds.openstack.keystone.v2_0.config.AuthenticationApiModule;
import org.jclouds.openstack.keystone.v2_0.config.KeystoneAuthenticationModule;
import org.jclouds.openstack.marconi.v1.MarconiApi;
import org.jclouds.openstack.marconi.v1.config.MarconiHttpApiModule;
import org.jclouds.openstack.marconi.v1.config.MarconiTypeAdapters;
import org.jclouds.rest.internal.BaseHttpApiMetadata;

@AutoService(value=ApiMetadata.class)
public class MarconiApiMetadata
extends BaseHttpApiMetadata<MarconiApi> {
    public Builder toBuilder() {
        return (Builder)new Builder().fromApiMetadata((ApiMetadata)this);
    }

    public MarconiApiMetadata() {
        this(new Builder());
    }

    protected MarconiApiMetadata(Builder builder) {
        super((BaseHttpApiMetadata.Builder)builder);
    }

    public static Properties defaultProperties() {
        Properties properties = BaseHttpApiMetadata.defaultProperties();
        properties.setProperty("jclouds.keystone.service-type", "queuing");
        properties.setProperty("jclouds.keystone.credential-type", "passwordCredentials");
        return properties;
    }

    public static class Builder
    extends BaseHttpApiMetadata.Builder<MarconiApi, Builder> {
        protected Builder() {
            ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id("openstack-marconi")).name("OpenStack Marconi Havana API")).identityName("${tenantName}:${userName} or ${userName}, if your keystone supports a default tenant")).credentialName("${password}")).documentation(URI.create("https://wiki.openstack.org/wiki/Marconi"))).version("1.0")).endpointName("Keystone base url ending in /v2.0/")).defaultEndpoint("http://localhost:5000/v2.0/")).defaultProperties(MarconiApiMetadata.defaultProperties())).defaultModules((Set)ImmutableSet.builder().add(AuthenticationApiModule.class).add(KeystoneAuthenticationModule.class).add(OkHttpCommandExecutorServiceModule.class).add(KeystoneAuthenticationModule.RegionModule.class).add(MarconiTypeAdapters.class).add(MarconiHttpApiModule.class).build());
        }

        public MarconiApiMetadata build() {
            return new MarconiApiMetadata(this);
        }

        protected Builder self() {
            return this;
        }
    }
}

