/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.marconi.v1.binders;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindIdsToQueryParam
implements Binder {
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument((boolean)(input instanceof Iterable), (Object)"This binder is only valid for Iterable");
        Iterable ids = (Iterable)input;
        Preconditions.checkArgument((Iterables.size((Iterable)ids) > 0 ? 1 : 0) != 0, (Object)"You must specify at least one id");
        return (R)request.toBuilder().replaceQueryParam("ids", new String[]{Joiner.on((char)',').join(ids)}).build();
    }
}

