/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.marconi.v1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.marconi.v1.domain.Message;

public class Claim {
    private final String id;
    private final int ttl;
    private final int age;
    private final List<Message> messages;

    protected Claim(String id, int ttl, int age, @Nullable List<Message> messages) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id required");
        this.ttl = ttl;
        this.age = age;
        this.messages = messages == null ? ImmutableList.of() : messages;
    }

    public String getId() {
        return this.id;
    }

    public int getTTL() {
        return this.ttl;
    }

    public int getAge() {
        return this.age;
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Claim that = (Claim)Claim.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("ttl", this.ttl).add("age", this.age).add("messages", this.messages);
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new ConcreteBuilder();
    }

    public Builder toBuilder() {
        return new ConcreteBuilder().fromMessage(this);
    }

    private static class ConcreteBuilder
    extends Builder {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder {
        protected String id;
        protected int ttl;
        protected int age;
        protected List<Message> messages;

        protected abstract Builder self();

        public Builder id(String id) {
            this.id = id;
            return this.self();
        }

        public Builder ttl(int ttl) {
            this.ttl = ttl;
            return this.self();
        }

        public Builder age(int age) {
            this.age = age;
            return this.self();
        }

        public Builder messages(List<Message> messages) {
            this.messages = messages;
            return this.self();
        }

        public Claim build() {
            return new Claim(this.id, this.ttl, this.age, this.messages);
        }

        public Builder fromMessage(Claim in) {
            return this.id(in.getId()).ttl(in.getTTL()).age(in.getAge()).messages(in.getMessages());
        }
    }
}

