/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.marconi.v1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.jclouds.javax.annotation.Nullable;

public class Queue {
    private final String name;
    private final Map<String, String> metadata;

    protected Queue(String name, @Nullable Map<String, String> metadata) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name required");
        this.metadata = metadata;
    }

    public String getName() {
        return this.name;
    }

    public Optional<Map<String, String>> getMetadata() {
        return Optional.fromNullable(this.metadata);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Queue that = (Queue)Queue.class.cast(obj);
        return Objects.equal((Object)this.name, (Object)that.name);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("name", (Object)this.name).add("metadata", this.metadata);
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new ConcreteBuilder();
    }

    public Builder toBuilder() {
        return new ConcreteBuilder().fromMessage(this);
    }

    private static class ConcreteBuilder
    extends Builder {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder {
        protected String name;
        protected Map<String, String> metadata;

        protected abstract Builder self();

        public Builder name(String name) {
            this.name = name;
            return this.self();
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this.self();
        }

        public Queue build() {
            return new Queue(this.name, this.metadata);
        }

        public Builder fromMessage(Queue in) {
            return this.name(in.getName()).metadata((Map)in.getMetadata().orNull());
        }
    }
}

