/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.marconi.v1.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.inject.Inject;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.openstack.marconi.v1.domain.Message;
import org.jclouds.openstack.marconi.v1.functions.ParseMessagesToStream;

public class ParseMessagesToList
implements Function<HttpResponse, List<Message>> {
    private final ParseJson<List<ParseMessagesToStream.MessageWithHref>> json;

    @Inject
    ParseMessagesToList(ParseJson<List<ParseMessagesToStream.MessageWithHref>> json) {
        this.json = (ParseJson)Preconditions.checkNotNull(json, (Object)"json");
    }

    public List<Message> apply(HttpResponse response) {
        if (response.getStatusCode() == 204) {
            return ImmutableList.of();
        }
        List messagesWithHref = (List)this.json.apply(response);
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)messagesWithHref, ParseMessagesToStream.TO_MESSAGE));
    }
}

