/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.marconi.v1.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.openstack.marconi.v1.domain.Aged;
import org.jclouds.openstack.marconi.v1.domain.MessagesStats;
import org.jclouds.openstack.marconi.v1.domain.QueueStats;
import org.jclouds.openstack.marconi.v1.functions.ParseMessagesToStream;

public class ParseQueueStats
implements Function<HttpResponse, QueueStats> {
    private final ParseJson<QueueStats> json;

    @Inject
    ParseQueueStats(ParseJson<QueueStats> json) {
        this.json = (ParseJson)Preconditions.checkNotNull(json, (Object)"json");
    }

    public QueueStats apply(HttpResponse from) {
        QueueStats rawQueueStats = (QueueStats)this.json.apply(from);
        if (rawQueueStats.getMessagesStats().getTotal() == 0) {
            return rawQueueStats;
        }
        Aged oldestWithHref = (Aged)rawQueueStats.getMessagesStats().getOldest().get();
        Aged oldestWithId = oldestWithHref.toBuilder().id((String)ParseMessagesToStream.TO_ID_FROM_HREF.apply((Object)oldestWithHref.getId())).build();
        Aged newestWithHref = (Aged)rawQueueStats.getMessagesStats().getNewest().get();
        Aged newestWithId = newestWithHref.toBuilder().id((String)ParseMessagesToStream.TO_ID_FROM_HREF.apply((Object)newestWithHref.getId())).build();
        MessagesStats messagesStatsWithIds = rawQueueStats.getMessagesStats().toBuilder().oldest(oldestWithId).newest(newestWithId).build();
        QueueStats queueStatsWithIds = rawQueueStats.toBuilder().messageStats(messagesStatsWithIds).build();
        return queueStatsWithIds;
    }
}

