/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.marconi.v1.domain;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import org.jclouds.http.utils.Queries;
import org.jclouds.openstack.marconi.v1.domain.Message;
import org.jclouds.openstack.marconi.v1.options.StreamMessagesOptions;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.domain.PaginatedCollection;

public class MessageStream
extends PaginatedCollection<Message> {
    private static final Predicate<Link> IS_NEXT_LINK = new Predicate<Link>(){

        public boolean apply(Link link) {
            return Link.Relation.NEXT == link.getRelation();
        }
    };
    private static final Function<Link, Object> TO_LIST_OPTIONS = new Function<Link, Object>(){

        public Object apply(Link link) {
            Multimap queryParams = (Multimap)Queries.queryParser().apply((Object)link.getHref().getRawQuery());
            StreamMessagesOptions paginationOptions = StreamMessagesOptions.Builder.queryParameters((Multimap<String, String>)queryParams);
            return paginationOptions;
        }
    };

    protected MessageStream(Iterable<Message> resources, Iterable<Link> links) {
        super(resources, links);
    }

    public StreamMessagesOptions nextStreamOptions() {
        return (StreamMessagesOptions)((Object)StreamMessagesOptions.class.cast(this.nextMarker().get()));
    }

    public Optional<Object> nextMarker() {
        Optional nextMarkerLink = Iterables.tryFind((Iterable)this.getLinks(), IS_NEXT_LINK);
        return nextMarkerLink.transform(TO_LIST_OPTIONS);
    }
}

