/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.marconi.v1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.marconi.v1.domain.Aged;

public class MessagesStats {
    private final int claimed;
    private final int free;
    private final int total;
    private final Aged oldest;
    private final Aged newest;

    @ConstructorProperties(value={"claimed", "free", "total", "oldest", "newest"})
    protected MessagesStats(int claimed, int free, int total, @Nullable Aged oldest, @Nullable Aged newest) {
        this.claimed = claimed;
        this.free = free;
        this.total = total;
        this.oldest = oldest;
        this.newest = newest;
    }

    public int getClaimed() {
        return this.claimed;
    }

    public int getFree() {
        return this.free;
    }

    public int getTotal() {
        return this.total;
    }

    public Optional<Aged> getOldest() {
        return Optional.fromNullable((Object)this.oldest);
    }

    public Optional<Aged> getNewest() {
        return Optional.fromNullable((Object)this.newest);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.claimed, this.free, this.total, this.oldest, this.newest});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MessagesStats that = (MessagesStats)MessagesStats.class.cast(obj);
        return Objects.equal((Object)this.claimed, (Object)that.claimed) && Objects.equal((Object)this.free, (Object)that.free) && Objects.equal((Object)this.total, (Object)that.total) && Objects.equal((Object)this.oldest, (Object)that.oldest) && Objects.equal((Object)this.newest, (Object)that.newest);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("claimed", this.claimed).add("free", this.free).add("total", this.total).add("oldest", (Object)this.oldest).add("newest", (Object)this.newest);
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new ConcreteBuilder();
    }

    public Builder toBuilder() {
        return new ConcreteBuilder().fromMessagesStats(this);
    }

    private static class ConcreteBuilder
    extends Builder {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder {
        protected int claimed;
        protected int free;
        protected int total;
        protected Aged oldest;
        protected Aged newest;

        protected abstract Builder self();

        public Builder claimed(int claimed) {
            this.claimed = claimed;
            return this.self();
        }

        public Builder free(int free) {
            this.free = free;
            return this.self();
        }

        public Builder total(int total) {
            this.total = total;
            return this.self();
        }

        public Builder oldest(Aged oldest) {
            this.oldest = oldest;
            return this.self();
        }

        public Builder newest(Aged newest) {
            this.newest = newest;
            return this.self();
        }

        public MessagesStats build() {
            return new MessagesStats(this.claimed, this.free, this.total, this.oldest, this.newest);
        }

        public Builder fromMessagesStats(MessagesStats in) {
            return this.claimed(in.getClaimed()).free(in.getFree()).total(in.getTotal()).oldest((Aged)in.getOldest().orNull()).newest((Aged)in.getNewest().orNull());
        }
    }
}

