/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.marconi.v1.domain;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.beans.ConstructorProperties;
import org.jclouds.http.utils.Queries;
import org.jclouds.openstack.marconi.v1.domain.Queue;
import org.jclouds.openstack.marconi.v1.options.ListQueuesOptions;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.domain.PaginatedCollection;

public class Queues
extends PaginatedCollection<Queue> {
    public static final Queues EMPTY = new Queues((Iterable<Queue>)ImmutableSet.of(), (Iterable<Link>)ImmutableSet.of());
    private static final Predicate<Link> IS_NEXT_LINK = new Predicate<Link>(){

        public boolean apply(Link link) {
            return Link.Relation.NEXT == link.getRelation();
        }
    };
    private static final Function<Link, Object> TO_LIST_OPTIONS = new Function<Link, Object>(){

        public Object apply(Link link) {
            Multimap queryParams = (Multimap)Queries.queryParser().apply((Object)link.getHref().getRawQuery());
            ListQueuesOptions listQueuesOptions = ListQueuesOptions.Builder.queryParameters((Multimap<String, String>)queryParams);
            return listQueuesOptions;
        }
    };

    @ConstructorProperties(value={"queues", "links"})
    protected Queues(Iterable<Queue> queues, Iterable<Link> links) {
        super(queues, links);
    }

    public ListQueuesOptions nextListQueuesOptions() {
        return (ListQueuesOptions)((Object)ListQueuesOptions.class.cast(this.nextMarker().get()));
    }

    public Optional<Object> nextMarker() {
        Optional nextMarkerLink = Iterables.tryFind((Iterable)this.getLinks(), IS_NEXT_LINK);
        return nextMarkerLink.transform(TO_LIST_OPTIONS);
    }
}

