/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.marconi.v1.features;

import java.util.List;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.marconi.v1.domain.Claim;
import org.jclouds.openstack.marconi.v1.domain.Message;
import org.jclouds.openstack.marconi.v1.functions.ParseClaim;
import org.jclouds.openstack.marconi.v1.functions.ParseMessagesToList;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.PATCH;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SkipEncoding;

@SkipEncoding(value={47, 61})
@RequestFilters(value={AuthenticateRequest.class})
@Consumes(value={"application/json"})
@Path(value="/claims")
public interface ClaimApi {
    @Named(value="claim:claim")
    @POST
    @Payload(value="%7B\"ttl\":{ttl},\"grace\":{grace}%7D")
    @ResponseParser(value=ParseMessagesToList.class)
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<Message> claim(@PayloadParam(value="ttl") int var1, @PayloadParam(value="grace") int var2, @QueryParam(value="limit") int var3);

    @Named(value="claim:get")
    @GET
    @Path(value="/{claim_id}")
    @ResponseParser(value=ParseClaim.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Claim get(@PathParam(value="claim_id") String var1);

    @Named(value="claim:update")
    @PATCH
    @Path(value="/{claim_id}")
    @Produces(value={"application/json"})
    @Payload(value="%7B\"ttl\":{ttl}%7D")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean update(@PathParam(value="claim_id") String var1, @PayloadParam(value="ttl") int var2);

    @Named(value="claim:delete")
    @DELETE
    @Path(value="/{claim_id}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean release(@PathParam(value="claim_id") String var1);
}

