/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.marconi.v1.features;

import java.util.List;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.v2_0.KeystoneFallbacks;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.marconi.v1.binders.BindIdsToQueryParam;
import org.jclouds.openstack.marconi.v1.domain.CreateMessage;
import org.jclouds.openstack.marconi.v1.domain.Message;
import org.jclouds.openstack.marconi.v1.domain.MessageStream;
import org.jclouds.openstack.marconi.v1.domain.MessagesCreated;
import org.jclouds.openstack.marconi.v1.functions.ParseMessage;
import org.jclouds.openstack.marconi.v1.functions.ParseMessagesCreated;
import org.jclouds.openstack.marconi.v1.functions.ParseMessagesToList;
import org.jclouds.openstack.marconi.v1.functions.ParseMessagesToStream;
import org.jclouds.openstack.marconi.v1.options.StreamMessagesOptions;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.binders.BindToJsonPayload;

@SkipEncoding(value={47, 61})
@RequestFilters(value={AuthenticateRequest.class})
@Consumes(value={"application/json"})
@Path(value="/messages")
public interface MessageApi {
    @Named(value="message:create")
    @POST
    @ResponseParser(value=ParseMessagesCreated.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public MessagesCreated create(@BinderParam(value=BindToJsonPayload.class) List<CreateMessage> var1);

    @Named(value="message:stream")
    @GET
    @ResponseParser(value=ParseMessagesToStream.class)
    @Fallback(value=KeystoneFallbacks.EmptyPaginatedCollectionOnNotFoundOr404.class)
    public MessageStream stream(StreamMessagesOptions ... var1);

    @Named(value="message:list")
    @GET
    @ResponseParser(value=ParseMessagesToList.class)
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<Message> list(@BinderParam(value=BindIdsToQueryParam.class) Iterable<String> var1);

    @Named(value="message:get")
    @GET
    @Path(value="/{message_id}")
    @ResponseParser(value=ParseMessage.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Message get(@PathParam(value="message_id") String var1);

    @Named(value="message:delete")
    @DELETE
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean delete(@BinderParam(value=BindIdsToQueryParam.class) Iterable<String> var1);

    @Named(value="message:delete")
    @DELETE
    @Path(value="/{message_id}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean deleteByClaim(@PathParam(value="message_id") String var1, @QueryParam(value="claim_id") String var2);
}

