/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.marconi.v1.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.beans.ConstructorProperties;
import java.util.List;
import javax.inject.Inject;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.openstack.marconi.v1.domain.Claim;
import org.jclouds.openstack.marconi.v1.domain.Message;
import org.jclouds.openstack.marconi.v1.functions.ParseMessagesToStream;

public class ParseClaim
implements Function<HttpResponse, Claim> {
    protected static final Function<ClaimWithHref, Claim> TO_CLAIM = new Function<ClaimWithHref, Claim>(){

        public Claim apply(ClaimWithHref claimWithHref) {
            ImmutableList messages = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)claimWithHref.messagesWithHref, ParseMessagesToStream.TO_MESSAGE));
            String claimId = (String)ParseMessagesToStream.TO_ID_FROM_HREF.apply((Object)claimWithHref.getId());
            return claimWithHref.toBuilder().id(claimId).messages((List<Message>)messages).build();
        }
    };
    private final ParseJson<ClaimWithHref> json;

    @Inject
    ParseClaim(ParseJson<ClaimWithHref> json) {
        this.json = (ParseJson)Preconditions.checkNotNull(json, (Object)"json");
    }

    public Claim apply(HttpResponse response) {
        ClaimWithHref claimWithHref = (ClaimWithHref)this.json.apply(response);
        Claim claim = (Claim)TO_CLAIM.apply((Object)claimWithHref);
        return claim;
    }

    private static class ClaimWithHref
    extends Claim {
        private final List<ParseMessagesToStream.MessageWithHref> messagesWithHref;

        @ConstructorProperties(value={"href", "ttl", "age", "messages"})
        protected ClaimWithHref(String href, int ttl, int age, List<ParseMessagesToStream.MessageWithHref> messagesWithHref) {
            super(href, ttl, age, null);
            this.messagesWithHref = messagesWithHref;
        }
    }
}

