/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.marconi.v1.functions;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.internal.ArgsToPagedIterable;
import org.jclouds.openstack.marconi.v1.MarconiApi;
import org.jclouds.openstack.marconi.v1.domain.Queue;
import org.jclouds.openstack.marconi.v1.features.QueueApi;
import org.jclouds.openstack.marconi.v1.options.ListQueuesOptions;
import org.jclouds.openstack.v2_0.domain.PaginatedCollection;
import org.jclouds.openstack.v2_0.options.PaginationOptions;

@Beta
public class QueuesToPagedIterable
extends ArgsToPagedIterable.FromCaller<Queue, QueuesToPagedIterable> {
    private final MarconiApi api;

    @Inject
    protected QueuesToPagedIterable(MarconiApi api) {
        this.api = (MarconiApi)Preconditions.checkNotNull((Object)api, (Object)"api");
    }

    protected Function<Object, IterableWithMarker<Queue>> markerToNextForArgs(List<Object> args) {
        String region = (String)String.class.cast(args.get(0));
        UUID clientId = (UUID)UUID.class.cast(args.get(1));
        return new ListQueuesAtMarker(this.api.getQueueApi(region, clientId));
    }

    private static class ListQueuesAtMarker
    implements Function<Object, IterableWithMarker<Queue>> {
        private final QueueApi api;

        @Inject
        protected ListQueuesAtMarker(QueueApi api) {
            this.api = (QueueApi)Preconditions.checkNotNull((Object)api, (Object)"api");
        }

        public PaginatedCollection<Queue> apply(Object input) {
            PaginationOptions paginationOptions = (PaginationOptions)PaginationOptions.class.cast(input);
            ListQueuesOptions listQueuesOptions = ListQueuesOptions.Builder.queryParameters((Multimap<String, String>)paginationOptions.buildQueryParameters());
            return this.api.list(listQueuesOptions);
        }

        public String toString() {
            return "ListRecordsAtMarker";
        }
    }
}

