/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.domain;

import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.neutron.v2.domain.NetworkType;

public class NetworkSegment {
    @Named(value="provider:network_type")
    protected final NetworkType networkType;
    @Named(value="provider:physical_network")
    protected final String physicalNetwork;
    @Named(value="provider:segmentation_id")
    protected final Integer segmentationId;

    @ConstructorProperties(value={"provider:network_type", "provider:physical_network", "provider:segmentation_id"})
    protected NetworkSegment(NetworkType networkType, String physicalNetwork, Integer segmentationId) {
        this.networkType = networkType;
        this.physicalNetwork = physicalNetwork;
        this.segmentationId = segmentationId;
    }

    @Nullable
    public NetworkType getNetworkType() {
        return this.networkType;
    }

    @Nullable
    public String getPhysicalNetwork() {
        return this.physicalNetwork;
    }

    @Nullable
    public Integer getSegmentationId() {
        return this.segmentationId;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.networkType, this.physicalNetwork, this.segmentationId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NetworkSegment that = (NetworkSegment)NetworkSegment.class.cast(obj);
        return Objects.equal((Object)((Object)this.networkType), (Object)((Object)that.networkType)) && Objects.equal((Object)this.physicalNetwork, (Object)that.physicalNetwork) && Objects.equal((Object)this.segmentationId, (Object)that.segmentationId);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("networkType", (Object)this.networkType).add("physicalNetwork", (Object)this.physicalNetwork).add("segmentationId", (Object)this.segmentationId);
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromNetworkSegment(this);
    }

    public static class Builder {
        protected NetworkType networkType;
        protected String physicalNetwork;
        protected Integer segmentationId;

        public Builder networkType(NetworkType networkType) {
            this.networkType = networkType;
            return this;
        }

        public Builder physicalNetwork(String physicalNetwork) {
            this.physicalNetwork = physicalNetwork;
            return this;
        }

        public Builder segmentationId(int segmentationId) {
            this.segmentationId = segmentationId;
            return this;
        }

        public NetworkSegment build() {
            return new NetworkSegment(this.networkType, this.physicalNetwork, this.segmentationId);
        }

        public Builder fromNetworkSegment(NetworkSegment in) {
            return this.networkType(in.getNetworkType()).physicalNetwork(in.getPhysicalNetwork()).segmentationId(in.getSegmentationId());
        }
    }
}

