/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.neutron.v2.domain.AddressPair;
import org.jclouds.openstack.neutron.v2.domain.ExtraDhcpOption;
import org.jclouds.openstack.neutron.v2.domain.IP;
import org.jclouds.openstack.neutron.v2.domain.NetworkStatus;
import org.jclouds.openstack.neutron.v2.domain.VIFType;
import org.jclouds.openstack.neutron.v2.domain.VNICType;

public class Port {
    private String id;
    private NetworkStatus status;
    @Named(value="binding:vif_type")
    private VIFType vifType;
    @Named(value="binding:vif_details")
    private ImmutableMap<String, Object> vifDetails;
    @Named(value="queue_id")
    private String qosQueueId;
    private String name;
    @Named(value="network_id")
    private String networkId;
    @Named(value="admin_state_up")
    private Boolean adminStateUp;
    @Named(value="mac_address")
    private String macAddress;
    @Named(value="fixed_ips")
    private ImmutableSet<IP> fixedIps;
    @Named(value="device_id")
    private String deviceId;
    @Named(value="device_owner")
    private String deviceOwner;
    @Named(value="tenant_id")
    private String tenantId;
    @Named(value="security_groups")
    private ImmutableSet<String> securityGroups;
    @Named(value="allowed_address_pairs")
    private ImmutableSet<AddressPair> allowedAddressPairs;
    @Named(value="extra_dhcp_opts")
    private ImmutableSet<ExtraDhcpOption> extraDhcpOptions;
    @Named(value="binding:vnic_type")
    private VNICType vnicType;
    @Named(value="binding:host_id")
    private String hostId;
    @Named(value="binding:profile")
    private ImmutableMap<String, Object> profile;
    @Named(value="port_security_enabled")
    private Boolean portSecurity;
    @Named(value="n1kv:profile_id")
    private String profileId;
    @Named(value="mac_learning_enabled")
    private Boolean macLearning;
    @Named(value="rxtx_factor")
    private Integer qosRxtxFactor;

    @ConstructorProperties(value={"id", "status", "binding:vif_type", "binding:vif_details", "queue_id", "name", "network_id", "admin_state_up", "mac_address", "fixed_ips", "device_id", "device_owner", "tenant_id", "security_groups", "allowed_address_pairs", "extra_dhcp_opts", "binding:vnic_type", "binding:host_id", "binding:profile", "port_security_enabled", "n1kv:profile_id", "mac_learning_enabled", "rxtx_factor"})
    protected Port(String id, NetworkStatus status, VIFType vifType, ImmutableMap<String, Object> vifDetails, String qosQueueId, String name, String networkId, Boolean adminStateUp, String macAddress, ImmutableSet<IP> fixedIps, String deviceId, String deviceOwner, String tenantId, ImmutableSet<String> securityGroups, ImmutableSet<AddressPair> allowedAddressPairs, ImmutableSet<ExtraDhcpOption> extraDhcpOptions, VNICType vnicType, String hostId, ImmutableMap<String, Object> profile, Boolean portSecurity, String profileId, Boolean macLearning, Integer qosRxtxFactor) {
        this.id = id;
        this.status = status;
        this.vifType = vifType;
        this.vifDetails = vifDetails;
        this.qosQueueId = qosQueueId;
        this.name = name;
        this.networkId = networkId;
        this.adminStateUp = adminStateUp;
        this.macAddress = macAddress;
        this.fixedIps = fixedIps;
        this.deviceId = deviceId;
        this.deviceOwner = deviceOwner;
        this.tenantId = tenantId;
        this.securityGroups = securityGroups;
        this.allowedAddressPairs = allowedAddressPairs;
        this.extraDhcpOptions = extraDhcpOptions;
        this.vnicType = vnicType;
        this.hostId = hostId;
        this.profile = profile;
        this.portSecurity = portSecurity;
        this.profileId = profileId;
        this.macLearning = macLearning;
        this.qosRxtxFactor = qosRxtxFactor;
    }

    private Port() {
    }

    private Port(Port port) {
        this(port.id, port.status, port.vifType, port.vifDetails, port.qosQueueId, port.name, port.networkId, port.adminStateUp, port.macAddress, port.fixedIps, port.deviceId, port.deviceOwner, port.tenantId, port.securityGroups, port.allowedAddressPairs, port.extraDhcpOptions, port.vnicType, port.hostId, port.profile, port.portSecurity, port.profileId, port.macLearning, port.qosRxtxFactor);
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    @Nullable
    public NetworkStatus getStatus() {
        return this.status;
    }

    @Nullable
    public VIFType getVifType() {
        return this.vifType;
    }

    @Nullable
    public ImmutableMap<String, Object> getVifDetails() {
        return this.vifDetails;
    }

    @Nullable
    public String getQosQueueId() {
        return this.qosQueueId;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getNetworkId() {
        return this.networkId;
    }

    @Nullable
    public Boolean getAdminStateUp() {
        return this.adminStateUp;
    }

    @Nullable
    public String getMacAddress() {
        return this.macAddress;
    }

    @Nullable
    public ImmutableSet<IP> getFixedIps() {
        return this.fixedIps;
    }

    @Nullable
    public String getDeviceId() {
        return this.deviceId;
    }

    @Nullable
    public String getDeviceOwner() {
        return this.deviceOwner;
    }

    @Nullable
    public String getTenantId() {
        return this.tenantId;
    }

    @Nullable
    public ImmutableSet<String> getSecurityGroups() {
        return this.securityGroups;
    }

    @Nullable
    public ImmutableSet<AddressPair> getAllowedAddressPairs() {
        return this.allowedAddressPairs;
    }

    @Nullable
    public ImmutableSet<ExtraDhcpOption> getExtraDhcpOptions() {
        return this.extraDhcpOptions;
    }

    @Nullable
    public VNICType getVnicType() {
        return this.vnicType;
    }

    @Nullable
    public String getHostId() {
        return this.hostId;
    }

    @Nullable
    public ImmutableMap<String, Object> getProfile() {
        return this.profile;
    }

    @Nullable
    public Boolean getPortSecurity() {
        return this.portSecurity;
    }

    @Nullable
    public String getProfileId() {
        return this.profileId;
    }

    @Nullable
    public Boolean getMacLearning() {
        return this.macLearning;
    }

    @Nullable
    public Integer getQosRxtxFactor() {
        return this.qosRxtxFactor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Port that = (Port)o;
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)((Object)this.status), (Object)((Object)that.status)) && Objects.equal((Object)((Object)this.vifType), (Object)((Object)that.vifType)) && Objects.equal(this.vifDetails, that.vifDetails) && Objects.equal((Object)this.qosQueueId, (Object)that.qosQueueId) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.networkId, (Object)that.networkId) && Objects.equal((Object)this.adminStateUp, (Object)that.adminStateUp) && Objects.equal((Object)this.macAddress, (Object)that.macAddress) && Objects.equal(this.fixedIps, that.fixedIps) && Objects.equal((Object)this.deviceId, (Object)that.deviceId) && Objects.equal((Object)this.deviceOwner, (Object)that.deviceOwner) && Objects.equal((Object)this.tenantId, (Object)that.tenantId) && Objects.equal(this.securityGroups, that.securityGroups) && Objects.equal(this.allowedAddressPairs, that.allowedAddressPairs) && Objects.equal(this.extraDhcpOptions, that.extraDhcpOptions) && Objects.equal((Object)((Object)this.vnicType), (Object)((Object)that.vnicType)) && Objects.equal((Object)this.hostId, (Object)that.hostId) && Objects.equal(this.profile, that.profile) && Objects.equal((Object)this.portSecurity, (Object)that.portSecurity) && Objects.equal((Object)this.profileId, (Object)that.profileId) && Objects.equal((Object)this.macLearning, (Object)that.macLearning) && Objects.equal((Object)this.qosRxtxFactor, (Object)that.qosRxtxFactor);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.status, this.vifType, this.vifDetails, this.qosQueueId, this.name, this.networkId, this.adminStateUp, this.macAddress, this.fixedIps, this.deviceId, this.deviceOwner, this.tenantId, this.securityGroups, this.allowedAddressPairs, this.extraDhcpOptions, this.vnicType, this.hostId, this.profile, this.portSecurity, this.profileId, this.macLearning, this.qosRxtxFactor});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("status", (Object)this.status).add("vifType", (Object)this.vifType).add("vifDetails", this.vifDetails).add("qosQueueId", (Object)this.qosQueueId).add("name", (Object)this.name).add("networkId", (Object)this.networkId).add("adminStateUp", (Object)this.adminStateUp).add("macAddress", (Object)this.macAddress).add("fixedIps", this.fixedIps).add("deviceId", (Object)this.deviceId).add("deviceOwner", (Object)this.deviceOwner).add("tenantId", (Object)this.tenantId).add("securityGroups", this.securityGroups).add("allowedAddressPairs", this.allowedAddressPairs).add("extraDhcpOptions", this.extraDhcpOptions).add("vnicType", (Object)this.vnicType).add("hostId", (Object)this.hostId).add("profile", this.profile).add("portSecurity", (Object)this.portSecurity).add("profileId", (Object)this.profileId).add("macLearning", (Object)this.macLearning).add("qosRxtxFactor", (Object)this.qosRxtxFactor).toString();
    }

    public static CreateBuilder createBuilder(String networkId) {
        return new CreateBuilder(networkId);
    }

    public static UpdateBuilder updateBuilder() {
        return new UpdateBuilder();
    }

    public static class UpdatePort
    extends Port {
        private UpdatePort(Port port) {
            super(port);
        }
    }

    public static class CreatePort
    extends Port {
        private CreatePort(Port port) {
            super(port);
            Preconditions.checkNotNull((Object)port.networkId, (Object)"networkId should not be null");
        }
    }

    public static class UpdateBuilder
    extends Builder<UpdateBuilder> {
        private UpdateBuilder() {
        }

        public UpdatePort build() {
            return new UpdatePort(this.port);
        }

        @Override
        protected UpdateBuilder self() {
            return this;
        }
    }

    public static class CreateBuilder
    extends Builder<CreateBuilder> {
        private CreateBuilder(String networkId) {
            this.port.networkId = networkId;
        }

        public CreatePort build() {
            return new CreatePort(this.port);
        }

        @Override
        protected CreateBuilder self() {
            return this;
        }
    }

    private static abstract class Builder<ParameterizedBuilderType> {
        protected Port port = new Port();

        private Builder() {
        }

        protected abstract ParameterizedBuilderType self();

        public ParameterizedBuilderType name(String name) {
            this.port.name = name;
            return this.self();
        }

        public ParameterizedBuilderType networkId(String networkId) {
            this.port.networkId = networkId;
            return this.self();
        }

        public ParameterizedBuilderType adminStateUp(Boolean adminStateUp) {
            this.port.adminStateUp = adminStateUp;
            return this.self();
        }

        public ParameterizedBuilderType macAddress(String macAddress) {
            this.port.macAddress = macAddress;
            return this.self();
        }

        public ParameterizedBuilderType fixedIps(ImmutableSet<IP> fixedIps) {
            this.port.fixedIps = fixedIps;
            return this.self();
        }

        public ParameterizedBuilderType deviceId(String deviceId) {
            this.port.deviceId = deviceId;
            return this.self();
        }

        public ParameterizedBuilderType deviceOwner(String deviceOwner) {
            this.port.deviceOwner = deviceOwner;
            return this.self();
        }

        public ParameterizedBuilderType tenantId(String tenantId) {
            this.port.tenantId = tenantId;
            return this.self();
        }

        public ParameterizedBuilderType securityGroups(ImmutableSet<String> securityGroups) {
            this.port.securityGroups = securityGroups;
            return this.self();
        }

        public ParameterizedBuilderType allowedAddressPairs(ImmutableSet<AddressPair> allowedAddressPairs) {
            this.port.allowedAddressPairs = allowedAddressPairs;
            return this.self();
        }

        public ParameterizedBuilderType extraDhcpOptions(ImmutableSet<ExtraDhcpOption> extraDhcpOptions) {
            this.port.extraDhcpOptions = extraDhcpOptions;
            return this.self();
        }

        public ParameterizedBuilderType vnicType(VNICType vnicType) {
            this.port.vnicType = vnicType;
            return this.self();
        }

        public ParameterizedBuilderType hostId(String hostId) {
            this.port.hostId = hostId;
            return this.self();
        }

        public ParameterizedBuilderType profile(ImmutableMap<String, Object> profile) {
            this.port.profile = profile;
            return this.self();
        }

        public ParameterizedBuilderType portSecurity(Boolean portSecurity) {
            this.port.portSecurity = portSecurity;
            return this.self();
        }

        public ParameterizedBuilderType profileId(String profileId) {
            this.port.profileId = profileId;
            return this.self();
        }

        public ParameterizedBuilderType macLearning(Boolean macLearning) {
            this.port.macLearning = macLearning;
            return this.self();
        }

        public ParameterizedBuilderType qosRxtxFactor(int qosRxtxFactor) {
            this.port.qosRxtxFactor = qosRxtxFactor;
            return this.self();
        }
    }
}

