/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.extensions;

import com.google.common.annotations.Beta;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.collect.PagedIterable;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.neutron.v2.domain.FloatingIP;
import org.jclouds.openstack.neutron.v2.domain.FloatingIPs;
import org.jclouds.openstack.neutron.v2.fallbacks.EmptyFloatingIPsFallback;
import org.jclouds.openstack.neutron.v2.functions.FloatingIPsToPagedIterable;
import org.jclouds.openstack.neutron.v2.functions.ParseFloatingIPs;
import org.jclouds.openstack.v2_0.options.PaginationOptions;
import org.jclouds.openstack.v2_0.services.Extension;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.annotations.WrapWith;

@Path(value="/floatingips")
@RequestFilters(value={AuthenticateRequest.class})
@Consumes(value={"application/json"})
@Extension(of="network", namespace="http://docs.openstack.org/ext/neutron/router/api/v1.0")
@Beta
public interface FloatingIPApi {
    @Named(value="floatingip:list")
    @GET
    @Transform(value=FloatingIPsToPagedIterable.class)
    @ResponseParser(value=ParseFloatingIPs.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<FloatingIP> list();

    @Named(value="floatingip:list")
    @GET
    @ResponseParser(value=ParseFloatingIPs.class)
    @Fallback(value=EmptyFloatingIPsFallback.class)
    public FloatingIPs list(PaginationOptions var1);

    @Named(value="floatingip:get")
    @GET
    @Path(value="/{id}")
    @SelectJson(value={"floatingip"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public FloatingIP get(@PathParam(value="id") String var1);

    @Named(value="floatingip:create")
    @POST
    @SelectJson(value={"floatingip"})
    public FloatingIP create(@WrapWith(value="floatingip") FloatingIP.CreateFloatingIP var1);

    @Named(value="floatingip:update")
    @PUT
    @Path(value="/{id}")
    @SelectJson(value={"floatingip"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public FloatingIP update(@PathParam(value="id") String var1, @WrapWith(value="floatingip") FloatingIP.UpdateFloatingIP var2);

    @Named(value="floatingip:delete")
    @DELETE
    @Path(value="/{id}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean delete(@PathParam(value="id") String var1);
}

