/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.features;

import com.google.common.collect.FluentIterable;
import java.util.List;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.collect.PagedIterable;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.neutron.v2.domain.Subnet;
import org.jclouds.openstack.neutron.v2.domain.Subnets;
import org.jclouds.openstack.neutron.v2.fallbacks.EmptySubnetsFallback;
import org.jclouds.openstack.neutron.v2.functions.ParseSubnets;
import org.jclouds.openstack.neutron.v2.functions.SubnetsToPagedIterable;
import org.jclouds.openstack.v2_0.options.PaginationOptions;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.annotations.WrapWith;

@Path(value="/subnets")
@RequestFilters(value={AuthenticateRequest.class})
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface SubnetApi {
    @Named(value="subnet:list")
    @GET
    @ResponseParser(value=ParseSubnets.class)
    @Transform(value=SubnetsToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Subnet> list();

    @Named(value="subnet:list")
    @GET
    @ResponseParser(value=ParseSubnets.class)
    @Fallback(value=EmptySubnetsFallback.class)
    public Subnets list(PaginationOptions var1);

    @Named(value="subnet:get")
    @GET
    @Path(value="/{id}")
    @SelectJson(value={"subnet"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Subnet get(@PathParam(value="id") String var1);

    @Named(value="subnet:create")
    @POST
    @SelectJson(value={"subnet"})
    public Subnet create(@WrapWith(value="subnet") Subnet.CreateSubnet var1);

    @Named(value="subnet:createBulk")
    @POST
    @SelectJson(value={"subnets"})
    public FluentIterable<Subnet> createBulk(@WrapWith(value="subnets") List<Subnet.CreateSubnet> var1);

    @Named(value="subnet:update")
    @PUT
    @Path(value="/{id}")
    @SelectJson(value={"subnet"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Subnet update(@PathParam(value="id") String var1, @WrapWith(value="subnet") Subnet.UpdateSubnet var2);

    @Named(value="subnet:delete")
    @DELETE
    @Path(value="/{id}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean delete(@PathParam(value="id") String var1);
}

