/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.poppy.v1.domain;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;
import org.jclouds.openstack.poppy.v1.domain.AutoValue_Caching;
import org.jclouds.openstack.poppy.v1.domain.CachingRule;

public abstract class Caching {
    public abstract String getName();

    public abstract int getTtl();

    @Nullable
    public abstract List<CachingRule> getRules();

    @SerializedNames(value={"name", "ttl", "rules"})
    static Caching create(String name, int ttl, List<CachingRule> rules) {
        return Caching.builder().name(name).ttl(ttl).rules(rules).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Caching.builder().name(this.getName()).ttl(this.getTtl()).rules(this.getRules());
    }

    public static final class Builder {
        private String name;
        private Integer ttl;
        private List<CachingRule> rules;

        Builder() {
        }

        Builder(Caching source) {
            this.name(source.getName());
            this.ttl(source.getTtl());
            this.rules(source.getRules());
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder ttl(int ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder rules(List<CachingRule> rules) {
            this.rules = rules;
            return this;
        }

        public Caching build() {
            String missing = "";
            if (this.name == null) {
                missing = missing + " name";
            }
            if (this.ttl == null) {
                missing = missing + " ttl";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            AutoValue_Caching result = new AutoValue_Caching(this.name, this.ttl, (List<CachingRule>)(this.rules != null ? ImmutableList.copyOf(this.rules) : null));
            return result;
        }
    }
}

