/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.poppy.v1.domain;

import org.jclouds.json.SerializedNames;
import org.jclouds.openstack.poppy.v1.domain.AutoValue_CachingRule;

public abstract class CachingRule {
    public abstract String getName();

    public abstract String getRequestURL();

    @SerializedNames(value={"name", "request_url"})
    private static CachingRule create(String name, String requestUrl) {
        return CachingRule.builder().name(name).requestURL(requestUrl).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return CachingRule.builder().name(this.getName()).requestURL(this.getRequestURL());
    }

    public static final class Builder {
        private String name;
        private String requestURL;

        Builder() {
        }

        Builder(CachingRule source) {
            this.name(source.getName());
            this.requestURL(source.getRequestURL());
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder requestURL(String requestURL) {
            this.requestURL = requestURL;
            return this;
        }

        public CachingRule build() {
            String missing = "";
            if (this.name == null) {
                missing = missing + " name";
            }
            if (this.requestURL == null) {
                missing = missing + " requestURL";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            AutoValue_CachingRule result = new AutoValue_CachingRule(this.name, this.requestURL);
            return result;
        }
    }
}

